      SUBROUTINE  iterb(fatal,nc,manual)
c
c...Full Array Iteration
c
      INCLUDE
     *         'ujproc.inc'
      PARAMETER
     *         npfudge = 100000,
     *         nitmax = 25
      INTEGER
     *         ok, err, nold, fatal, nc, manual, niter
c
 9001 FORMAT (' Fatal Error In Pairfit')
 9002 FORMAT (' NPAIR=', i8, '  Sx=', f10.2, '   Sx=', f10.2,
     *        '  NCoef=', i2, '  Niter=', i2)
 9003 FORMAT (' Enter Find Radius (Micron): ' $)
 9004 FORMAT (f10.0)
c
c...Initialization
c
  100 rmicron = 20.0
      zonerad = -1
c
c...Zone Processing
c
  105 CALL zoneproc(manual)
c
c...Loop At This Set Of Conditions
c
      nold = npair
      niter = 0
  110 CALL xformpar
      CALL pairpar
      CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 9
        RETURN
      ENDIF
      CALL pairfit(y1, ycoef,sycoef,sigmay, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 10
        RETURN
      ENDIF
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      WRITE (*,9002) npair,sigmax,sigmay,ncoef,niter
c
c...Iterate Until NPAIR Is The Same
c
      IF (manual.le.0) THEN
        IF (zonerad.gt.0) THEN
          IF (ABS(npair-nold).lt.(MAX(npair,nold)/10)) GO TO 105
        ENDIF
        IF (ABS(npair-nold).gt.(npair/NPFUDGE)) THEN
          nold = npair
          niter = niter+1
          IF (niter.gt.NITMAX) THEN
            fatal = 17
            RETURN
          ENDIF
          IF ((niter.ge.2).and.(npair.le.100)) THEN
            fatal = 18
            RETURN
          ENDIF
          IF ((niter.ge.4).and.(npair.le.3000)) THEN
            fatal = 19
            RETURN
          ENDIF
          GO TO 110
        ENDIF
      ELSE
        CALL isitok(ok)
        IF (ok.ge.0) THEN
          IF (ok.eq.0) THEN
  120       WRITE (*,9003)
            READ  (*,9004,err=120,end=200) rmicron
            GO TO 110
          ELSEIF (ok.eq.1) THEN
            GO TO 110
          ELSEIF (ok.eq.2) THEN
            GO TO 105
          ENDIF
        ENDIF
      ENDIF
c
c...Try Bigger Zone
c
      IF (zonerad.gt.0) GO TO 105
c
c...Final (Hopefully Quick) Iteration For More Plate Constants)
c
      IF (nc.ne.ncoef) THEN
        ncoef = nc
  130   CALL pairpar
        CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
        IF (err.ne.0) THEN
          WRITE (*,9001)
          fatal = 7
          RETURN
        ENDIF
        CALL pairfit(y1, ycoef,sycoef,sigmay, err)
        IF (err.ne.0) THEN
          WRITE (*,9001)
          fatal = 8
          RETURN
        ENDIF
        sigmax = 0.01D00*sigmax
        sigmay = 0.01D00*sigmay
        WRITE (*,9002) npair,sigmax,sigmay,ncoef
        IF (ABS(npair-nold).gt.(npair/NPFUDGE)) THEN
          nold = npair
          CALL xformpar
          GO TO 130
        ENDIF
      ENDIF
c
c...Compute Magnitude Transformation If PHD File Was Found
c
      IF (newmag.ne.0) THEN
        CALL magproc
      ENDIF
      RETURN
c
c...Read EOF
c
  200 CALL EXIT
      END
