      PROGRAM  gencddir
c
c...Generate Survey CD-ROM Directories
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nfmax = 1100,
     *         nsmax = 8,
     *         numax = 3,
     *         nqmax = 11,
     *         nkmax = 100
      INTEGER
     *         s, f, u, ndir(NFMAX,NSMAX), sunit(NUMAX), nlb, cdnum,
     *         sfmax(NUMAX), semax(NUMAX), sfrst(NUMAX), slast(NUMAX),
     *         sx(NSMAX), nplate(NFMAX,NQMAX), nstar(NFMAX,NQMAX),
     *         q, n, sp, tp, nkill, killsx(NKMAX), killid(NKMAX), i, j
      DOUBLE PRECISION
     *         ss, sq, ts, tq
      CHARACTER*132
     *         lb
      CHARACTER*13
     *         cddir, dir(NFMAX,NSMAX)
      CHARACTER*8
     *         sname(NUMAX)
      CHARACTER*2
     *         si(NSMAX), scdid(NUMAX), who
      DATA
     *   sname/'p1cd.dir', 'p2cd.dir', 'sscd.dir'/,
     *   sunit/    11    ,     12    ,     13    /,
     *   sfmax/  1037    ,    894    ,    894    /,
     *   semax/     2    ,      4    ,      2    /,
     *   sfrst/     1    ,      3    ,      7    /,
     *   slast/     2    ,      6    ,      8    /,
     *   scdid/   'se'   ,    'sj'   ,    'sb'   /
      DATA
     *   si/'so', 'se', 'uj', 'sj', 'sf', 'sn', 'sb', 'sr'/,
     *   sx/  1 ,   2 ,   3 ,   4 ,   5 ,   6 ,   7 ,   8 /
c
 9001 FORMAT (2i5, 4(1x,a))
 9002 FORMAT (i3.3)
 9003 FORMAT (i4)
 9004 FORMAT ('/uy6/cd/se', i3.3)
 9005 FORMAT (q, a)
 9006 FORMAT (' Duplicate Entry For ', a, 2(' >>', a, '<<'))
 9007 FORMAT (a, i4.4, 1x)
 9008 FORMAT (a, i4.4, 1x, a, '/', a, i4.4, 'a.inf')
 9009 FORMAT (i3)
 9010 FORMAT (' Length Error For ', 3i5, ' >>', a, '<<')
 9011 FORMAT (i12)
 9012 FORMAT (i2, i5, 2f20.1)
 9013 FORMAT (a, i4)
 9014 FORMAT (' Unknown Kill Survey >>', a, '<<', i10)
 9015 FORMAT (' NKILL=', i10)
 9016 FORMAT (' Killed ', a)
c
c...Initialize
c
  100 DO s=1,NSMAX
        DO f=1,NFMAX
          ndir(f,s) = -1
        ENDDO
      ENDDO
      DO q=1,NQMAX
        DO f=1,NFMAX
          nplate(f,q) = 0
        ENDDO
      ENDDO
c
c...Read KILLER File
c
      nkill = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=106,
     *      form='formatted',
     *      name='killer',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  102 READ (1,9013,end=104) who,j
      DO i=1,NSMAX
        IF (who.eq.si(i)) THEN
          nkill = nkill+1
          killsx(nkill) = sx(i)
          killid(nkill) = j
          GO TO 102
        ENDIF
      ENDDO
      WRITE (*,9014) who,j
      GO TO 102
  104 CLOSE (1)
  106 WRITE (*,9015) nkill
c
c...Open Output Files
c
      DO u=1,NUMAX
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=sname(u),
     *        status='unknown',
     *        unit=sunit(u)
     *       )
        WRITE (sunit(u),9001) semax(u),sfmax(u),
     *                        (si(s),s=sfrst(u),slast(u))
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='gencddir.log',
     *      status='unknown',
     *      unit=3
     *     )
c
c...Open Input File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/etc/xfstab',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
c
c...Outer Loop Reads XFSTAB For CD-ROM Names.  Consider Only Ours.
c
  110 READ (1,9005,err=110,end=160) nlb,lb
      IF (nlb.lt.13) GO TO 110
      cddir = lb(nlb-12:nlb)
      IF (cddir(1:8).ne.'/uy6/cd/') GO TO 110
      READ (cddir(11:13),9009,err=110) cdnum
      DO u=1,NUMAX
        IF (cddir(9:10).eq.scdid(u)) GO TO 120
        IF ((u.eq.2).and.(cddir(9:10).eq.'uj')) GO TO 120
      ENDDO
      GO TO 110
c
c...This Is One Of Our CD-ROMs.  Get Its Directory And Mark These Entries.
c
  120 CALL system('ls -l '//cddir//' >tmp.lis')
      write (*,9992) cddir
 9992 format (' TMP Holds ', a)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='tmp.lis',
     *      status='old',
     *      unit=2
     *       )
  130 READ (2,9005,err=130,end=150) nlb,lb
      IF (nlb.le.10) GO TO 130
      IF (lb(nlb-3:nlb).ne.'.dat') GO TO 130
      READ (lb(nlb-8:nlb-5),9003,err=130) f
      IF ((f.le.0).or.(f.gt.sfmax(u))) GO TO 130
      DO s=sfrst(u),slast(u)
        IF (lb(nlb-10:nlb-9).eq.si(s)) GO TO 140
      ENDDO
      GO TO 130
c
c...Remove KILLER List
c
  140 DO i=1,nkill
        IF ((killsx(i).eq.sx(s)).and.(killid(i).eq.f)) THEN
          WRITE (*,9016) lb(1:nlb)
          WRITE (3,9016) lb(1:nlb)
          GO TO 130
        ENDIF
      ENDDO
c
c...For An "a" File, Add It To The Directory List
c
      IF (lb(nlb-4:nlb-4).eq.'a') THEN
        IF (ndir(f,s).gt.0) THEN
          WRITE (*,9006) lb(1:nlb),dir(f,s),cddir
          WRITE (3,9006) lb(1:nlb),dir(f,s),cddir
        ENDIF
        IF (cdnum.gt.ndir(f,s)) THEN
          ndir(f,s) = cdnum
          dir(f,s) = cddir
        ENDIF
      ENDIF
c
c...Compute Q Index For Sub-Divided Surveys
c
      IF (s.eq.2) THEN
        IF (f.le.937) THEN
          q = s
        ELSE
          q = 9
        ENDIF
      ELSEIF (s.eq.7) THEN
        IF (f.le.606) THEN
          q = s
        ELSE
          q = 10
        ENDIF
      ELSEIF (s.eq.8) THEN
        IF (f.le.606) THEN
          q = s
        ELSE
          q = 11
        ENDIF
      ELSE
        q = s
      ENDIF
c
c...For An "a" File, Add It To The Plate Count List
c
      IF (lb(nlb-4:nlb-4).eq.'a') THEN
        nplate(f,q) = 1
        nstar(f,q) = 0
      ENDIF
c
c...For Any File, Accumulate The Star Count
c
      READ (lb(nlb-34:nlb-25),9011) n
      IF (MOD(n,52).ne.0) THEN
        WRITE (*,9010) s,q,n,lb(nlb-10:nlb)
      ENDIF
      nstar(f,q) = nstar(f,q)+(n/52)
c
c...All Done With This Entry
c
      GO TO 130
  150 CLOSE (2)
      GO TO 110
  160 CLOSE (1)
c
c...Scribble The Rest Of The Directory File
c
      DO u=1,NUMAX
        DO f=1,sfmax(u)
          DO s=sfrst(u),slast(u)
            IF (ndir(f,s).lt.0) THEN
              WRITE (sunit(u),9007) si(s),f
            ELSE
              WRITE (sunit(u),9008) si(s),f,dir(f,s),si(s),f
            ENDIF
          ENDDO
        ENDDO
      ENDDO
      DO u=1,NUMAX
        CLOSE (unit=sunit(u))
      ENDDO
      CLOSE (3)
c
c...Save Accumulated Statistics
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='cddir.stat',
     *      status='unknown',
     *      unit=1
     *     )
      tp = 0
      ts = 0.0D00
      tq = 0.0D00
      DO q=1,NQMAX
        sp = 0
        ss = 0.0D00
        DO f=1,NFMAX
          sp = sp+nplate(f,q)
          tp = tp+nplate(f,q)
          ss = ss+nstar(f,q)
          ts = ts+nstar(f,q)
        ENDDO
        IF (q.eq.8) THEN
          sq = sp*1394.0D00*1037.0D00*432.0D00
        ELSE
          sq = sp*1394.0D00*1037.0D00*588.0D00
        ENDIF
        IF (q.ne.3) THEN
          tq = tq+sq
        ENDIF
        WRITE (1,9012) q,sp,ss,sq
      ENDDO
      q = 0
      WRITE (1,9012) q,tp,ts,tq
      CLOSE (1)
      CALL EXIT
      END
