      SUBROUTINE  eatp2
c
c...Ingest POSS2 Field Centers
c
      INCLUDE
     *            'centers.inc'
      DOUBLE PRECISION
     *            rcur, dcur, r2000, d2000, cur
      CHARACTER*5
     *            who
      CHARACTER*1
     *            dsign
      INTEGER
     *            rhh, rmm, rss, ddd, dmm, dss, i, field
c
 9001 FORMAT (i6, 14x, f2.0, 7x, 3i2, 1x, a, 3i2, 21x, a)
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uy6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      DO i=1,NMAX
        jfind(i) = 0
        ffind(i) = 0
        nfind(i) = 0
      ENDDO
c
c...Read Each Entry, Precess, And Save
c
  110 READ (1,9001,end=120) field,cur,rhh,rmm,rss,dsign,ddd,dmm,dss,who
      IF ((field.lt.0).or.(field.gt.894)) GO TO 110
      cur = cur+1900.0D00
      rcur = (rhh + rmm/60.0D00 + rss/3600.0D00)*twopi/24.0D00
      dcur = (ddd + dmm/60.0D00 + dss/3600.0D00)*twopi/360.0D00
      IF (dsign.eq.'-') THEN
        dcur = -dcur
      ENDIF
      r2000 = rcur
      d2000 = dcur
      CALL sla_PRECES('FK5',cur,2000.0D00,r2000,d2000)
      p2ra(field) = r2000*24.0D00/twopi
      p2dec(field) = d2000*360.0D00/twopi
      IF (who(5:5).eq.'J') THEN
        jfind(field) = 1
      ELSEIF (who(5:5).eq.'F') THEN
        ffind(field) = 1
      ELSEIF (who(3:3).eq.'N') THEN
        nfind(field) = 1
      ENDIF
      GO TO 110
  120 CLOSE (1)
      RETURN
      END
