      SUBROUTINE  docheck2
c
c...Check Magnitudes
c
      INCLUDE
     *            'check.inc'
      PARAMETER
     *            minmag = 800,
     *            maxmag = 1500
      DOUBLE PRECISION
     *            sm, smm, sn, rm, s
      INTEGER
     *            i, m1, m2
c
 9001 FORMAT (' DOCHECK2 M=', f8.3, '+/-', f8.3, '  N=', i10)
c
c...Initialization
c
      open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='c2.out',status='unknown',unit=11)
  100 sm = 0.0D00
      smm = 0.0D00
      sn = 0.0D00
c
c...Loop Over Pairs
c
      DO i=1,npover
        m1 = mag(pover(i,1),1)
        m2 = mag(pover(i,2),2)
        IF ((m1.gt.0).and.(m2.gt.0)) THEN
      write (11,9998) m1,m2
 9998 format (2i10)
          IF ((m2.ge.MINMAG).and.(m2.lt.MAXMAG)) THEN
            rm = m1-m2
            sm = sm + rm
            smm = smm + rm*rm
            sn = sn + 1.0D00
          ENDIF
        ENDIF
      ENDDO
c
c...Compute Statistics
c
      IF (sn.ge.1.0D00) THEN
        sm = sm/sn
        IF (sn.eq.1.0D00) THEN
          smm = 0.0D00
        ELSE
          smm = SQRT(smm/sn - sm*sm)
        ENDIF
      ENDIF
      i = sn+0.5D00
c
c...Scale So As Not To Scare The User
c
      s = 0.01D00
      sm = sm*s
      smm = smm*s
      WRITE (*,9001) sm,smm,i
      close (11)
      RETURN
      END
