      PROGRAM  hist
c
c...Histogram Of RAW Errors
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         boxnum = 25,
     *         np = boxnum+1
      CHARACTER*64
     *         lb
      INTEGER
     *         nlb, i, j, k, l
      REAL
     *         x, y, xbox(BOXNUM), ybox(BOXNUM), px(NP), py(NP),
     *         xmin, xmax, ymin, ymax, zbox(BOXNUM)
c
 9001 FORMAT (' Enter File For LogHist: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (3i10)
c
c...Initialization
c
  100 DO i=1,BOXNUM
        xbox(i) = i+0.5
      ENDDO
c
c...Read File
c
  110 WRITE (*,9001)
      READ  (*,9002,err=110) nlb,lb
      IF (nlb.le.0) GO TO 110
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,BOXNUM
        READ (1,9003) l,j,k
        IF (j.eq.0) THEN
          ybox(i) = 0.0
        ELSE
          ybox(i) = ALOG10(REAL(j))
        ENDIF
        IF (k.eq.0) THEN
          zbox(i) = 0.0
        ELSE
          zbox(i) = ALOG10(REAL(k))
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Make MONGO Data Arrays
c
      xmin = 2.0
      xmin = xbox(1)
      xmax = xbox(BOXNUM)
      ymin = 0.5
      ymax = 4.5
      CALL mgosetup(-7)
      CALL mgoinit
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,2)
      CALL mgosetltype(0)
      CALL mgohistogram(xbox,ybox,BOXNUM)
      CALL mgosetltype(1)
      CALL mgohistogram(xbox,zbox,BOXNUM)
      CALL mgoxlabel(21, 'Field 421 - Magnitude')
      CALL mgoylabel(13, 'LOG10(Number)')
      CALL mgoprntplot(i)
      CALL EXIT
      END
