      PROGRAM  fourcorn
c
c...Make A List Of POSS-I and POSS-II Fields
c
      INCLUDE
     *         'p12.inc'
      INTEGER
     *         nin, fin(20), fp1(20), fp2(20), i, j, nlb, nfp1, nfp2,
     *         loop, dummy(20)
      DOUBLE PRECISION
     *         ra(4), dec(4), ramin, ramax, decmin, decmax, epoch
      CHARACTER*64
     *         lb
c
 9001 FORMAT (' Enter  RA MIN,MAX[,EPOCH]: ' $)
 9002 FORMAT (' Enter Dec MIN,MAX: ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (3f10.0)
 9005 FORMAT (' POSS- I Fields: ' 10i4)
 9006 FORMAT (' POSS-II Fields: ' 10i4)
 9007 FORMAT (' Setting Epoch=', f6.1)
c
c...Initialize and Get RA/DEC
c
  100 CALL p12init
  110 WRITE (*,9001)
      READ  (*,9003,err=110,end=200) nlb,lb
      IF (nlb.le.0) GO TO 200
      READ (lb(1:nlb),9004,err=110) ramin,ramax,epoch
      IF (epoch.le.0.0D00) THEN
        epoch = 2000.0
      ELSEIF (epoch.lt.100.0D00) THEN
        epoch = 1900.0D00+epoch
      ENDIF
      WRITE (*,9007) epoch
      WRITE (*,9002)
      READ  (*,9003,err=110,end=200) nlb,lb
      IF (nlb.le.0) GO TO 200
      READ (lb(1:nlb),9004,err=110) decmin,decmax
      ra(1) = ramin
      dec(1) = decmin
      ra(2) = ramin
      dec(2) = decmax
      ra(3) = ramax
      dec(3) = decmin
      ra(4) = ramax
      dec(4) = decmax
c
c...Outer Loop Over Corners
c
      nfp1 = 0
      nfp2 = 0
      DO loop=1,4
c
c...Check POSS-I
c
        nin = 0
        CALL p1eplist(ra(loop),dec(loop),nin,fin,epoch)
        DO i=1,nin
          DO j=1,nfp1
            IF (fin(i).eq.fp1(j)) GO TO 120
          ENDDO
          nfp1 = nfp1+1
          fp1(nfp1) = fin(i)
  120     CONTINUE
        ENDDO
c
c...Check POSS-II
c
        nin = 0
        CALL p2eplist(ra(loop),dec(loop),nin,fin,epoch)
        DO i=1,nin
          DO j=1,nfp2
            IF (fin(i).eq.fp2(j)) GO TO 130
          ENDDO
          nfp2 = nfp2+1
          fp2(nfp2) = fin(i)
  130     CONTINUE
        ENDDO
c
c...All Done
c
      ENDDO
      DO i=1,nfp1
        dummy(i) = i
      ENDDO
      CALL iuqsrt(nfp1,fp1,dummy)
      DO i=1,nfp2
        dummy(i) = i
      ENDDO
      CALL iuqsrt(nfp2,fp2,dummy)
      WRITE (*,9005) (fp1(i),i=1,nfp1)
      WRITE (*,9006) (fp2(i),i=1,nfp2)
      GO TO 110
  200 CALL EXIT
      END
