      PROGRAM  p12list
c
c...Make A List Of POSS-I and POSS-II Fields
c
      INCLUDE
     *         'p12.inc'
      INTEGER
     *         nin, fin(20), fp1(20), fp2(20), i, j, nlb, nfp1, nfp2
      DOUBLE PRECISION
     *         ra, dec, rr, rd
      CHARACTER*64
     *         lb
c
 9001 FORMAT (' Enter RA,Dec: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (2f10.0)
 9004 FORMAT (' POSS- I Fields: ' 10i4)
 9005 FORMAT (' POSS-II Fields: ' 10i4)
c
c...Initialize and Get RA/DEC
c
  100 CALL p12init
  110 WRITE (*,9001)
      READ  (*,9002,err=110,end=200) nlb,lb
      IF (nlb.le.0) GO TO 200
      READ (lb(1:nlb),9003,err=110) ra,dec
      rr = 15.0D00*ra/radian
      rd = dec/radian
c
c...Check POSS-I
c
      nfp1 = 0
      nin = 0
      CALL p1list(rr,rd,nin,fin)
      DO i=1,nin
        DO j=1,nfp1
          IF (fin(i).eq.fp1(j)) GO TO 110
        ENDDO
        nfp1 = nfp1+1
        fp1(nfp1) = fin(i)
      ENDDO
      WRITE (*,9004) (fp1(i),i=1,nfp1)
c
c...Check POSS-II
c
      nfp2 = 0
      nin = 0
      CALL p2list(ra,dec,nin,fin)
      DO i=1,nin
        DO j=1,nfp2
          IF (fin(i).eq.fp2(j)) GO TO 120
        ENDDO
        nfp2 = nfp2+1
        fp2(nfp2) = fin(i)
  120   CONTINUE
      ENDDO
      WRITE (*,9005) (fp2(i),i=1,nfp2)
c
c...All Done
c
      GO TO 110
  200 CALL EXIT
      END
