      PROGRAM  p1touch
c
c...Make A List Of POSS-I Plates That Touch
c
      INCLUDE
     *            'p12.inc'
      PARAMETER
     *            nn = 5
      INTEGER
     *            i, j, neach, ntotal, each(20), total(20), field,
     *            x, y
      DOUBLE PRECISION
     *            r0, d0, z, zx, zy, r, d
c
 9001 FORMAT (20i4)
c
c...Initialization
c
  100 radian = 45.0D00/ATAN(1.0D00)
      ra_to_rad = 15.0D00/radian
      dec_to_rad = 1.0D00/radian
      CALL p12init
      zwide = 6.8D00*zwide/6.5D00
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='p1touch.dat',
     *      status='unknown',
     *      unit=1
     *     )
c
c...Compute NNxNN Grid
c
      DO field=1,NP1
        r0 = p1ra(field)
        d0 = p1dec(field)
        ntotal = 0
        z = (SIZE*SCALE/3600.0D00)/radian
        DO y=-NN,NN
          zy = (y*z)/NN
          DO x=-NN,NN
            zx = (x*z)/NN
            CALL sla_DTP2S(zx,zy,r0,d0,r,d)
            CALL p1list(r,d,neach,each)
            DO i=1,neach
              DO j=1,ntotal
                IF (total(j).eq.each(i)) GO TO 110
              ENDDO
              ntotal = ntotal+1
              total(ntotal) = each(i)
  110         CONTINUE
            ENDDO
          ENDDO
        ENDDO
c
c...Remove Self And Degenerate Field
c
        j = 0
        DO i=1,ntotal
          IF ((total(i).ne.field).and.(total(i).ne.724)) THEN
            j = j+1
            total(j) = total(i)
          ENDIF
        ENDDO
        ntotal = j
        DO i=1,ntotal
          each(i) = i
        ENDDO
        CALL iuqsrt(ntotal,total,each)
        WRITE (1,9001) field,ntotal,(total(i),i=1,ntotal)
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
