      PROGRAM  p2corn
c
c...Make The CORNER File
c
      IMPLICIT
     *            NONE
      INCLUDE
     *            'p2corn.inc'
      PARAMETER
     *            delta = 6.5D00*25.4D00,
     *            scale = 67.18D00
      INTEGER
     *            i, id
      DOUBLE PRECISION
     *            rhh, rmm, rss, ddd, dmm, dss, r1950, d1950,
     *            r2000, d2000, radian, ra_to_rad, dec_to_rad,
     *            r0, d0, z
      CHARACTER*1
     *            dsign
c
 9001 FORMAT (i4, 3f3.0)
c
c...Initialization
c
  100 radian = 45.0D00/ATAN(1.0D00)
      ra_to_rad = 15.0D00/radian
      dec_to_rad = 1.0D00/radian
c
c...Read Nominals.  These Are B1950
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='centers.dat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NP2
        READ (1,9001) id,ddd,rhh,rmm
        IF (id.ne.i) THEN
          STOP 'POSS-II Out Of Order'
        ENDIF
        d1950 = ddd*dec_to_rad
        r1950 = (rhh + rmm/60.0D00)*ra_to_rad
        CALL sla_FK45Z(r1950,d1950,1950.0D00,r2000,d2000)
        p2ra(i) = r2000
        p2dec(i) = d2000
      ENDDO
      CLOSE (1)
c
c...Compute Corners
c
      DO i=1,NP2
        r0 = p2ra(i)
        d0 = p2dec(i)
        z = (DELTA*SCALE/3600.0D00)/radian
        CALL sla_DTP2S(-z,-z,r0,d0,p2rc(1,i),p2dc(1,i))
        CALL sla_DTP2S( z,-z,r0,d0,p2rc(2,i),p2dc(2,i))
        CALL sla_DTP2S(-z, z,r0,d0,p2rc(3,i),p2dc(3,i))
        CALL sla_DTP2S( z, z,r0,d0,p2rc(4,i),p2dc(4,i))
      ENDDO
c
c...Save It
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='p2corn.dat',
     *      recl=(20*NP2),
     *      recordtype='fixed',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,rec=1) p2buf
      CLOSE (1)
      CALL EXIT
      END
