      PROGRAM  p2over
c
c...Make The Overlaps File
c
      INCLUDE
     *            'p12.inc'
      PARAMETER
     *            nn = 5,
     *            tol = 0.0175D00
      INTEGER
     *            i, j, neach, ntotal, each(20), total(20), field,
     *            x, y
      DOUBLE PRECISION
     *            r0, d0, z, zx, zy, r, d, sep, sla_DSEP, ll, bb
c
 9001 FORMAT (20i4)
 9002 FORMAT (2i4, f10.2, 4f10.5)
c
c...Initialization
c
  100 radian = 45.0D00/ATAN(1.0D00)
      ra_to_rad = 15.0D00/radian
      dec_to_rad = 1.0D00/radian
      CALL p12init
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='p2over.dat',
     *      status='unknown',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='p2over.sep',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Compute NNxNN Grid
c
      DO field=1,NP2
        r0 = p2ra(field)
        d0 = p2dec(field)
        ntotal = 0
        z = (SIZE*SCALE/3600.0D00)/radian
        DO y=-NN,NN
          zy = (y*z)/NN
          DO x=-NN,NN
            zx = (x*z)/NN
            CALL sla_DTP2S(zx,zy,r0,d0,r,d)
            CALL p1list(r,d,neach,each)
            DO i=1,neach
              DO j=1,ntotal
                IF (total(j).eq.each(i)) GO TO 110
              ENDDO
              ntotal = ntotal+1
              total(ntotal) = each(i)
  110         CONTINUE
            ENDDO
          ENDDO
        ENDDO
        DO i=1,ntotal
          each(i) = i
        ENDDO
        CALL iuqsrt(ntotal,total,each)
        WRITE (1,9001) field,ntotal,(total(i),i=1,ntotal)
c
c...See If Any Are Really Close
c
        DO i=1,ntotal
          j = total(i)
          sep = sla_DSEP(p2ra(field),p2dec(field),p1ra(j),p1dec(j))
          IF (sep.le.TOL) THEN
            CALL sla_EG50(p2ra(field),p2dec(field),ll,bb)
            r = p2ra(field)*radian/15.0D00
            d = p2dec(field)*radian
            ll = ll*radian
            bb = bb*radian
            sep = sep*radian
            WRITE (2,9002) field,j,sep,r,d,ll,bb
          ENDIF
        ENDDO
      ENDDO
      CLOSE (1)
      CLOSE (2)
      CALL EXIT
      END
