      program glop
      call gscsearch
      call exit
      end
c
c
c
      subroutine gscsearch(ra1,ra2,dec1,dec2)

      IMPLICIT INTEGER*2 (I-N)
      CHARACTER*3 HRS,DEG
      CHARACTER*2 MIN
      CHARACTER*7 SEC
      CHARACTER*1 PTYPE,STELLAR
      CHARACTER*20 TITLE
      COMMON/PARAMS/PSCL,RADIUS
     1,FMAGLIM,DR,CON,CONA,PTYPE,STELLAR
c
  3   format(t1,(a))
c
      CON=atan(1.0)/45.0
      CONA=atan(1.0)/3.0
c Open UNIT=3 on the REGIONS.GSC file
      OPEN(UNIT=3,
     &  FILE='/reef/lib/REGIONS.GSC',
     &  STATUS='OLD',
     &  ACCESS='DIRECT',
c    &  RECL=16)	! DEC fortran uses 4-byte record length
     &  RECL=4,err=99)
c
    6 FORMAT(F10.0)
c
      PSCL=CON
      ptype = 'R'
c
c All strips will be 180 degrees long in RA
c
      write(6,3) 'Searching GSC. . .'
	stellar = 'Y'
        FMAGLIM=20.
      CALL DOSEARCH(ra1,ra2,dec1,dec2)
	return
c
 99   write(6,3) 'Error opening GSC regions file.'
      return
c
      END
c
c
c
      SUBROUTINE DOSEARCH(ra1,ra2,dec1,dec2)
c
      IMPLICIT INTEGER*2 (I-N)
      DIMENSION LARREG(300),DLO(4),DHI(4),RLO(4),RHI(4)
      INTEGER*2 SMALL0,SREGION
      LOGICAL*1 RAFLAG,DECFLAG,FLAG
      CHARACTER*1 PTYPE,STELLAR
      COMMON/PARAMS/PSCL,RADIUS
     1,FMAGLIM,DR,CON,CONA,PTYPE,STELLAR
c
C     DECLO,DECHI are the low and high DEC limits on the plate (degrees)
C     RALO,RAHI are the low and high  RA limits on the plate (hours)
      ralo = ra1
      rahi = ra2
      declo = dec1
      dechi = dec2
      IF(RALO.LT.0.) RALO=RALO+24.
      IF(RALO.GE.24.) RALO=RALO-24.
      IF(RAHI.LT.0.) RAHI=RAHI+24.
      IF(RAHI.GT.24.) RAHI=RAHI-24.
      IF(RALO.GT.RAHI) THEN
         TEMP=RALO
         RALO=RAHI
         RAHI=TEMP
      ENDIF
C     Set RAFLAG if we cross 0/24 hour boundary. Sec DECFLAG if we cross 0 deg.
      RAFLAG=.FALSE.
      DECFLAG=.FALSE.
      IF(RAHI-RALO.GT.12.) RAFLAG=.TRUE.
      IF(DECLO*DECHI.LT.0.) DECFLAG=.TRUE.
      IF(.NOT.RAFLAG.AND..NOT.DECFLAG) THEN
C        Case 1 -- we do not cross either boundary.  Only one center
         RLO(1)=RALO
         RHI(1)=RAHI
         DLO(1)=DECLO
         DHI(1)=DECHI
         NCASE=1
      ELSEIF(.NOT.RAFLAG.AND.DECFLAG) THEN
C        Case 2 -- we cross 0 dec, but not 0 ra. Two centers.
         RLO(1)=RALO
         RHI(1)=RAHI
         DLO(1)=0.
         DHI(1)=DECHI
         RLO(2)=RALO
         RHI(2)=RAHI
         DLO(2)=DECLO
         DHI(2)=0.
         NCASE=2
      ELSEIF(RAFLAG.AND..NOT.DECFLAG) THEN
C        Case 3 -- we cross 0 ra, but not 0 dec.  Two centers.
         RLO(1)=RAHI
         RHI(1)=24.
         DLO(1)=DECLO
         DHI(1)=DECHI
         RLO(2)=0.
         RHI(2)=RALO
         DLO(2)=DECLO
         DHI(2)=DECHI
         NCASE=2
      ELSEIF(RAFLAG.AND.DECFLAG) THEN
C        Case 4 -- cross both 0 ra and 0 dec.  Four cases.
         RLO(1)=RAHI
         RHI(1)=24.
         DLO(1)=0.
         DHI(1)=DECHI
         RLO(2)=0.
         RHI(2)=RALO
         DLO(2)=0.
         DHI(2)=DECHI
         RLO(3)=RAHI
         RHI(3)=24.
         DLO(3)=DECLO
         DHI(3)=0.
         RLO(4)=0.
         RHI(4)=RALO
         DLO(4)=DECLO
         DHI(4)=0.
         NCASE=4
      ENDIF
C     Find all the large area region numbers on the plate starting in the
C     SW corner (lower right).  Do subplate by subplate if there are subplates.
      NL=0
      DO 1 JJ=1,NCASE
C        Get the region number, and the strip parameters.
         DECL=DLO(JJ)
99       CALL LARGE(RLO(JJ),DECL,NREG0,D0,DRA,NLO,NHI)
C        RA, DEC limits on this corner large region
         RA0HI=(NREG0-NLO+1)*DRA
         RA0LO=RA0HI-DRA
         DEC0HI=D0+3.75
         DEC0LO=D0-3.75
C        Have we moved off the plate in dec?
         IF(DEC0LO.GT.DHI(JJ)) GO TO 1
         NL=NL+1
         LARREG(NL)=NREG0
C        Start at NREG0 and move to higher RA until we run off plate or 
C        run to 24 hours at region NHI in this zone
         NREG=NREG0
         RALO=RA0LO
2        NREG=NREG+1
         RALO=RALO+DRA
         IF(NREG.GT.NHI.OR.RALO.GT.RHI(JJ)) THEN
            GO TO 4
         ELSE
            NL=NL+1
            LARREG(NL)=NREG
            GO TO 2
         ENDIF
C        Now move north one zone and repeat the process until we reach 90
C        or until we run off the plate
4        DECL=DECL+7.5
         IF(DECL.LE.90.) GO TO 99
1     CONTINUE
C     Sort and remove duplicates
      CALL CLEAN(NL,LARREG)
C     For each large region, get the small regions contained within it
      DO 5 JJ=1,NL
C        Large region LARREG(JJ) contains small regions SMALL0 thru
c        SMALL01+K**2
         CALL SMALINX(LARREG(JJ),SMALL0,K)
         DO 6 SREGION=SMALL0,SMALL0+K**2 -1
C           Open the region on unit 1 and get number of stars and starting
C           record
            CALL CDOPEN(SREGION,NUMSTR,NREC)
C           Is this small region within the desired area?
            CALL TESTREG(SREGION,ra1,ra2,dec1,dec2,FLAG)
C           Check stars only if all or part of the small region is OK
            IF(FLAG) CALL TESTDATA(NUMSTR,NREC,SREGION,ra1,ra2,dec1
     *                             dec2)
            CLOSE(UNIT=1)
6        CONTINUE
5     CONTINUE
      RETURN
      END
c
c
c
      SUBROUTINE CLEAN(NL,LARGE)
      IMPLICIT INTEGER*2 (I-N)
      INTEGER*2 LARGE(1)
      LOGICAL*1 SORT
C
C     Sort the NL entries in LARGE and remove duplicates.  Return
C     new value of NL
C
      DO 1 JJ=1,NL
         SORT=.FALSE.
         DO 2 JK=1,NL-1
            IF(LARGE(JK).GT.LARGE(JK+1)) THEN
               SORT=.TRUE.
               ITEM=LARGE(JK)
               LARGE(JK)=LARGE(JK+1)
               LARGE(JK+1)=ITEM
            ENDIF
2        CONTINUE
         IF(.NOT.SORT) GO TO 3
1     CONTINUE
3     NCT=1
      DO 4 JJ=2,NL
        IF(LARGE(JJ).NE.LARGE(JJ-1)) THEN
           NCT=NCT+1
           LARGE(NCT)=LARGE(JJ)
        ENDIF
4     CONTINUE
      NL=NCT
      RETURN
      END
c
c
c
      SUBROUTINE LARGE(RA,DEC,NUM,D0,DRA,N1,N2)
      IMPLICIT INTEGER*2 (I-N)
      INTEGER*2 NZONE(12),SZONE(12)
C
C     Given an RA, DEC (hours,deg) return:
C
C     NUM -  Large region number containing RA,DEC
C     D0  -  Center of DEC zone which contains region NUM
C     DRA -  Width in RA of the large regions in this zone (hours)
C     N1  -  Number of 1st large region in this zone (runs 0 to DRA hours)
C     N2  -  Number of last large region in this zone (runs 24-DRA to 24 hours)
C
      DATA NZONE/1,49,96,141,184,224,260,292,319,340,355,364/
      DATA SZONE/367,415,462,507,550,590,626,658,685,706,721,730/
C
      CON=atan(1.0)/45.0
      IF(DEC.GE.0.) THEN
         NZ=INT(DEC/7.5)+1
         D0=(NZ-1)*7.5+3.75
         NR=NINT(48.0*COS(D0*CON))
         N1=NZONE(NZ)
         N2=N1+NR-1
         DRA=24./NR
      ELSE
         NZ=INT(ABS(DEC)/7.5)+1
         D0=-(NZ-1)*7.5-3.75
         NR=NINT(48.0*COS(D0*CON))
         N1=SZONE(NZ)
         N2=N1+NR-1
         DRA=24./NR
      ENDIF
      RAT=RA
      IF(RAT.EQ.24.) RAT=24.
      NOFF=RAT/DRA
      NUM=N1+NOFF
      RETURN
      END
c
c
c
      SUBROUTINE CDOPEN(SREGION,NUMSTR,NREC)
      IMPLICIT INTEGER*2 (I-N)
      DIMENSION N1(25)
      CHARACTER*5 FNAME(24),FILE
      INTEGER*2 SREGION
      CHARACTER*2880 LINE
      CHARACTER*80 OLINE
      CHARACTER*8 FILNAM
      CHARACTER*6 DISK
C
C     Open the file associated with small region SREGION on UNIT=1
C     Return the number of stars and the starting record number of the data
C
      DATA N1/1,594,1178,1729,2259,2781,3246,3652,4014,4294,4492
     1,4615,4663,5260,5838,6412,6989,7523,8022,8464,8840,9134,9346
     1,9490,9538/
      DATA FNAME/'N0000','N0730','N1500','N2230','N3000','N3730'
     1,'N4500','N5230','N6000','N6730','N7500','N8230','S0000'
     1,'S0730','S1500','S2230','S3000','S3730','S4500','S5230'
     1,'S6000','S6730','S7500','S8230'/
      DATA FILNAM/'    .GSC'/
      WRITE(UNIT=FILNAM(1:4),FMT=109) SREGION
109   FORMAT(I4.4)
      DO 1 JJ=1,24
         IF(SREGION.GE.N1(JJ).AND.SREGION.LT.N1(JJ+1)) THEN
            FILE=FNAME(JJ)
            GO TO 2
         ENDIF
1     CONTINUE
      STOP 'Error in small region number'

2     DISK = '/gscn/'
      IF (JJ.GE.14) DISK = '/gscs/'
      OPEN(UNIT=1,
     1	READONLY,
     2  FILE=DISK//'GSC/'//FILE//'/'//FILNAM,
     3  ACCESS='DIRECT',
     4  RECL=720,
     5  STATUS='OLD',
     6  recordtype='fixed',
     6  iostat=ios,
     7  ERR=9999)
C     Read the extension FITS header and get the number of stars
C     Keep reading till the END to get starting record for data
      NN=2
1000  READ(1,REC=NN) LINE
      DO 15 JJ=1,36
        NL=(JJ-1)*80+1
        NH=NL+79
        OLINE=LINE(NL:NH)
        IF(OLINE(1:6).EQ.'NAXIS2') THEN
           READ(UNIT=OLINE(11:30),FMT=101) NUMSTR
101        FORMAT(I20)
        ELSEIF(OLINE(1:3).EQ.'END') THEN
C          Data starts in next record
           NREC=NN+1
           GO TO 5000
        ENDIF
15    CONTINUE
      NN=NN+1
      GO TO 1000
5000  RETURN
9999  IF(JJ.GE.14) THEN
         WRITE(6,3)
3        FORMAT(1X,'Please put in Southern CD and press return',$)
      ELSE
         WRITE(6,4)
4        FORMAT(1X,'Please put in Northern CD and press return',$)
	 write(6,113)ios
113	format(' ios = ',a,/)
      ENDIF
      READ(5,11) IDUM
11    FORMAT(I10)
      GO TO 2
      END
c
c
c
      SUBROUTINE SMALINX(LARGE,SMALL0,K)
      IMPLICIT INTEGER*2 (I-N)
      INTEGER*2 SMALL0
      INTEGER*2 SREG(732),IK(732)
C
C     Give large region LARGE, return the starting small region, SMALL0
C     and the size K.
C
      DATA (SREG(JJ),JJ=1,108)/
     1               1 ,  10 ,  19 ,  28 ,  37 ,  46 ,  55 ,  64 ,  73 ,  
     1  82 ,  98 , 114 , 130 , 146 , 162 , 178 , 194 , 210 , 226 , 235 ,
     1 244 , 253 , 262 , 271 , 280 , 289 , 298 , 307 , 316 , 325 , 334 ,
     1 350 , 366 , 382 , 398 , 414 , 430 , 446 , 462 , 478 , 494 , 510 ,
     1 526 , 542 , 558 , 567 , 576 , 585 , 594 , 603 , 612 , 621 , 630 ,
     1 639 , 648 , 657 , 666 , 682 , 698 , 714 , 730 , 746 , 762 , 778 ,
     1 794 , 810 , 819 , 828 , 837 , 846 , 855 , 864 , 873 , 882 , 891 ,
     1 900 , 909 , 918 , 927 , 943 , 959 , 975 , 991 ,1007 ,1023 ,1039 ,
     11055 ,1071 ,1087 ,1103 ,1119 ,1135 ,1151 ,1160 ,1169 ,1178 ,1187 ,
     11196 ,1205 ,1214 ,1223 ,1232 ,1248 ,1264 ,1280 ,1296 ,1312 ,1328/
      DATA (SREG(JJ),JJ=109,218)/
     11344 ,1360 ,1376 ,1392 ,1401 ,1410 ,1419 ,1428 ,1437 ,1441 ,1445 ,
     11449 ,1458 ,1467 ,1476 ,1485 ,1494 ,1503 ,1519 ,1535 ,1551 ,1567 ,
     11583 ,1599 ,1615 ,1631 ,1647 ,1663 ,1679 ,1695 ,1711 ,1720 ,1729 ,
     11738 ,1747 ,1756 ,1765 ,1781 ,1797 ,1813 ,1829 ,1845 ,1861 ,1877 ,
     11893 ,1909 ,1925 ,1941 ,1950 ,1959 ,1968 ,1977 ,1981 ,1985 ,1989 ,
     11993 ,1997 ,2006 ,2015 ,2024 ,2033 ,2042 ,2058 ,2074 ,2090 ,2106 ,
     12122 ,2138 ,2154 ,2170 ,2186 ,2202 ,2218 ,2234 ,2250 ,2259 ,2275 ,
     12291 ,2307 ,2323 ,2339 ,2355 ,2371 ,2387 ,2403 ,2419 ,2435 ,2451 ,
     12467 ,2483 ,2492 ,2501 ,2510 ,2519 ,2523 ,2527 ,2531 ,2535 ,2544 ,
     12553 ,2562 ,2571 ,2580 ,2589 ,2605 ,2621 ,2637 ,2653 ,2669 ,2685/
      DATA (SREG(JJ),JJ=219,328)/
     12701 ,2717 ,2733 ,2749 ,2765 ,2781 ,2797 ,2813 ,2829 ,2845 ,2861 ,
     12877 ,2893 ,2909 ,2925 ,2941 ,2957 ,2973 ,2982 ,2991 ,3000 ,3009 ,
     13013 ,3017 ,3021 ,3025 ,3034 ,3043 ,3052 ,3061 ,3070 ,3086 ,3102 ,
     13118 ,3134 ,3150 ,3166 ,3182 ,3198 ,3214 ,3230 ,3246 ,3262 ,3278 ,
     13294 ,3310 ,3326 ,3342 ,3358 ,3374 ,3390 ,3406 ,3415 ,3424 ,3433 ,
     13442 ,3451 ,3455 ,3459 ,3463 ,3472 ,3481 ,3490 ,3499 ,3508 ,3524 ,
     13540 ,3556 ,3572 ,3588 ,3604 ,3620 ,3636 ,3652 ,3668 ,3684 ,3700 ,
     13716 ,3732 ,3748 ,3764 ,3780 ,3796 ,3805 ,3814 ,3823 ,3832 ,3841 ,
     13850 ,3859 ,3868 ,3877 ,3886 ,3902 ,3918 ,3934 ,3950 ,3966 ,3982 ,
     13998 ,4014 ,4030 ,4046 ,4062 ,4078 ,4094 ,4110 ,4126 ,4135 ,4144/
      DATA (SREG(JJ),JJ=329,438)/
     14153 ,4162 ,4171 ,4180 ,4189 ,4198 ,4214 ,4230 ,4246 ,4262 ,4278 ,
     14294 ,4310 ,4326 ,4342 ,4358 ,4374 ,4383 ,4392 ,4401 ,4410 ,4419 ,
     14428 ,4444 ,4460 ,4476 ,4492 ,4508 ,4524 ,4540 ,4549 ,4558 ,4567 ,
     14583 ,4599 ,4615 ,4631 ,4647 ,4663 ,4672 ,4681 ,4685 ,4689 ,4698 ,
     14707 ,4716 ,4725 ,4734 ,4750 ,4766 ,4782 ,4798 ,4814 ,4830 ,4846 ,
     14862 ,4878 ,4894 ,4903 ,4912 ,4921 ,4930 ,4939 ,4948 ,4957 ,4966 ,
     14975 ,4984 ,5000 ,5016 ,5032 ,5048 ,5064 ,5080 ,5096 ,5112 ,5128 ,
     15144 ,5160 ,5176 ,5192 ,5208 ,5224 ,5233 ,5242 ,5251 ,5260 ,5269 ,
     15273 ,5277 ,5281 ,5285 ,5294 ,5303 ,5312 ,5321 ,5330 ,5346 ,5362 ,
     15378 ,5394 ,5410 ,5426 ,5442 ,5458 ,5474 ,5490 ,5499 ,5508 ,5517/
      DATA (SREG(JJ),JJ=439,548)/
     15526 ,5535 ,5544 ,5553 ,5562 ,5578 ,5594 ,5610 ,5626 ,5642 ,5658 ,
     15674 ,5690 ,5706 ,5722 ,5738 ,5754 ,5770 ,5786 ,5802 ,5811 ,5820 ,
     15829 ,5838 ,5847 ,5851 ,5855 ,5859 ,5863 ,5872 ,5881 ,5890 ,5899 ,
     15915 ,5931 ,5947 ,5963 ,5979 ,5995 ,6011 ,6027 ,6043 ,6059 ,6075 ,
     16084 ,6093 ,6102 ,6111 ,6120 ,6136 ,6152 ,6168 ,6184 ,6200 ,6216 ,
     16232 ,6248 ,6264 ,6280 ,6296 ,6312 ,6328 ,6344 ,6360 ,6376 ,6385 ,
     16394 ,6403 ,6412 ,6421 ,6425 ,6429 ,6433 ,6437 ,6446 ,6455 ,6464 ,
     16473 ,6489 ,6505 ,6521 ,6537 ,6553 ,6569 ,6585 ,6601 ,6617 ,6633 ,
     16649 ,6665 ,6681 ,6697 ,6713 ,6729 ,6745 ,6761 ,6777 ,6793 ,6809 ,
     16825 ,6841 ,6857 ,6873 ,6889 ,6905 ,6921 ,6937 ,6953 ,6962 ,6971/
      DATA (SREG(JJ),JJ=549,658)/
     16980 ,6989 ,6998 ,7002 ,7006 ,7010 ,7019 ,7028 ,7037 ,7046 ,7055 ,
     17071 ,7087 ,7103 ,7119 ,7135 ,7151 ,7167 ,7183 ,7199 ,7215 ,7231 ,
     17247 ,7263 ,7279 ,7295 ,7311 ,7327 ,7343 ,7359 ,7375 ,7391 ,7407 ,
     17423 ,7439 ,7455 ,7471 ,7487 ,7496 ,7505 ,7514 ,7523 ,7532 ,7541 ,
     17550 ,7559 ,7568 ,7577 ,7586 ,7595 ,7611 ,7627 ,7643 ,7659 ,7675 ,
     17691 ,7707 ,7723 ,7739 ,7755 ,7771 ,7787 ,7803 ,7819 ,7835 ,7851 ,
     17867 ,7883 ,7899 ,7915 ,7931 ,7947 ,7963 ,7979 ,7995 ,8004 ,8013 ,
     18022 ,8031 ,8040 ,8049 ,8058 ,8067 ,8076 ,8085 ,8101 ,8117 ,8133 ,
     18149 ,8165 ,8181 ,8197 ,8213 ,8229 ,8245 ,8261 ,8277 ,8293 ,8309 ,
     18325 ,8341 ,8357 ,8373 ,8389 ,8405 ,8421 ,8437 ,8446 ,8455 ,8464/
      DATA (SREG(JJ),JJ=659,732)/
     18473 ,8482 ,8491 ,8500 ,8509 ,8518 ,8534 ,8550 ,8566 ,8582 ,8598 ,
     18614 ,8630 ,8646 ,8662 ,8678 ,8694 ,8710 ,8726 ,8742 ,8758 ,8774 ,
     18790 ,8806 ,8822 ,8831 ,8840 ,8849 ,8858 ,8867 ,8876 ,8892 ,8908 ,
     18924 ,8940 ,8956 ,8972 ,8988 ,9004 ,9020 ,9036 ,9052 ,9068 ,9084 ,
     19100 ,9116 ,9125 ,9134 ,9143 ,9152 ,9161 ,9177 ,9193 ,9209 ,9225 ,
     19241 ,9257 ,9273 ,9289 ,9305 ,9321 ,9337 ,9346 ,9362 ,9378 ,9394 ,
     19410 ,9426 ,9442 ,9458 ,9474 ,9490 ,9506 ,9522 /                  
      DATA (IK(JJ),JJ=1,127)/
     1          3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,
     13,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,
     14,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,
     13,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,3,3,3,3,3,3,4,4/
      DATA(IK(JJ),JJ=128,259)/
     14,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,2,
     12,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,4,4,4,4,4,4,4,4,
     14,4,4,4,3,3,3,3,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     14,4,4,4,4,4,4,4,4,3,3,3,3,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4/
      DATA (IK(JJ),JJ=260,391)/
     14,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,
     14,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     13,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,4,4,4,4,4,4,4,3,
     13,3,4,4,4,4,4,4,3,3,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3/
      DATA(IK(JJ),JJ=392,523)/
     13,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,3,3,3,3,3,
     14,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     13,3,3,3,3,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,4,4,4,4,
     14,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,4/
      DATA(IK(JJ),JJ=524,655)/
     14,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,3,3,3,
     13,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,
     13,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     13,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3/
      DATA (IK(JJ),JJ=656,732)/
     13,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,
     14,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,4,
     14,4,4,4,4,4,4,4,4,4,4/                                            
C
      SMALL0=SREG(LARGE)
      K=IK(LARGE)
      RETURN
      END
c
c
c
      SUBROUTINE TESTDATA(NUMSTR,NREC,SREGION,ra1,ra2,dec1,dec2)
      IMPLICIT INTEGER*2 (I-N)
      CHARACTER*2880 LINE
      CHARACTER*45 DATA
      CHARACTER*1 PTYPE,STELLAR
      INTEGER*2 SREGION
      LOGICAL*1 FLAG,INSIDE
c
      include 'gsc2ubv.inc'
c
      real*8 gscra(MXNGSC), gscdec(MXNGSC), d2r, raad, deccd
      real*4 gscmag(MXNGSC)
      integer*4 gscicnt
      integer*2 gscreg(MXNGSC), gscsnum(MXNGSC)
      common/gscstrip/gscra, gscdec, gscmag, gscreg, gscsnum, gscicnt
C     
      COMMON/PARAMS/PSCL,RADIUS
     1,FMAGLIM,DR,CON,CONA,PTYPE,STELLAR
c
      d2r = datan(1.0d0)/4.5d1
c
C     Read the stars from the file open on UNIT=1 and write out if they
C     lie within the plate
C     Read data records until NUMSTR stars have been found
      NR=NREC
9999  NCT=0
3000  READ(1,REC=NR) LINE
      DO 2 JJ=1,64
        N1=(JJ-1)*45+1
        N2=N1+44
        NCT=NCT+1
        DATA=LINE(N1:N2)
        READ(UNIT=DATA(40:40),FMT=197) ICLASS
197     FORMAT(I1)
C       Skip if this is a non stellar object and we want stellar
        IF(STELLAR.EQ.'Y'.AND.ICLASS.NE.0) GO TO 12
        READ(UNIT=DATA(29:33),FMT=198) VMAG
198     FORMAT(F5.2)
C       Skip if fainter than our limit
        IF(VMAG.GT.FMAGLIM) GO TO 12
C       Convert RA and Dec (in deg)
        READ(UNIT=DATA(6:14),FMT=199) RAA
199     FORMAT(F9.5)
        READ(UNIT=DATA(15:23),FMT=199) DECC
        IF (15.0*ra1.le.raa .and. raa.lt.15.0*ra2 .and. dec1.lt.decc
     &   .and. decc.le.dec2) then
           gscicnt = gscicnt + 1
           gscreg(gscicnt) = sregion
           gscsnum(gscicnt) = nct
           read(UNIT=DATA(6:14),FMT=199) raad
           read(UNIT=DATA(15:23),FMT=199) deccd
           gscra(gscicnt) = d2r*raad
           gscdec(gscicnt) = d2r*deccd
           gscmag(gscicnt) = vmag
        ENDIF
12      IF(NCT.EQ.NUMSTR) RETURN
2     CONTINUE
      NR=NR+1
      GO TO 3000
      END
c
c
c
      SUBROUTINE TESTREG(SREGION,ra1,ra2,dec1,dec2,FLAG)
c
      IMPLICIT INTEGER*2 (I-N)
      real dtemp
      INTEGER*2 SREGION
      LOGICAL*1 FLAG
      CHARACTER*1 PTYPE,STELLAR
C
C     Test small region SREGION.  If it is entirely outside the requested
C     region, set FLAG=.FALSE.
C
      COMMON/PARAMS/PSCL,RADIUS
     1,FMAGLIM,DR,CON,CONA,PTYPE,STELLAR
C
C Get boundaries of region and check that at least one corner is inside
C the plate.  The units of angle read from the CD are radians.
C
      READ(3,REC=SREGION) RALO,RAHI,DECLO,DECHI
      if( declo .gt. dechi ) then
         dtemp = declo
         declo = dechi
         dechi = dtemp
      end if
c Sometimes RALO<24 and RAHI=0.0, so we need to make RAHI=24.0
      if( rahi .lt. ralo ) rahi = rahi + 8.0*atan(1.0)
      FLAG=.TRUE.
      IF(ralo.gt.ra2*cona) flag = .false.
      IF(rahi.lt.ra1*cona) flag = .false.
      IF(dechi.lt.dec1*con) flag = .false.
      IF(declo.gt.dec2*con) flag = .false.
c
      RETURN
      END 
