#include	<stdlib.h>
#include	<termio.h>
#include	<signal.h>
#include	<string.h>
#include	<errno.h>
#include	<sys/time.h>
/*
 ************************************************************************
 *
 *   c_rawline  --  Read Until Return Or ^Z
 */
c_rawline_(bb)
char bb[];
{
	struct termio a, b;
	char c;
	int nbb, ret, i;
	static char er[3] = {8, 32, 8};
	static char crnl[2] = {13, 10};
	static char ctlz[4] = {'^','Z',13,10};
/*
 *   Configure For Raw Input
 */
	ioctl(0, TCGETA, &a);
	ioctl(0, TCGETA, &b);
	b.c_lflag &= (~(ISIG|ICANON|ECHO));
	b.c_cc[VMIN] = 1;
	b.c_cc[VTIME] = 10;
	ioctl(0, TCSETA, &b);
	nbb = 0;
	ret = 1;
/*
 *  We Gotta Do Everything
 *
 *	Ignore Errors Since Interrupts Cause Them
 */
	while (ret > 0) {
		while (read(0,&c,1) != 1)
			;
		c &= 127;
		switch (c) {

		case 10:
		case 13:
			write(1,crnl,2);
			ret = 0;
			break;

		case 26:
			write(1,ctlz,4);
			ret = (-1);
			break;

		case 8:
		case 127:
			if (nbb > 0) {
				write(1,er,3);
				nbb--;
			}
			break;

		case 18:
			for (i=0; i<nbb; i++)
				write(1,er,3);
			write(1,bb,nbb);
			break;

		case 21:
			for (i=0; i<nbb; i++)
				write(1,er,3);
			nbb = 0;
			break;

		default:
			bb[nbb++] = c;
			write(1,&c,1);
			break;
		}
	}
/*
 *  Recover The Terminal And Exit
 */
	ioctl(0, TCSETA, &a);
	bb[nbb] = '\0';
	return(ret);
}
/*
 **************************************************************************
 *
 *   doenv
 */
c_doenv_(in,out)
char in[],out[];
{
	if (getenv(in) != NULL)
		strcpy(out,getenv(in));
	else
		strcpy(out,in);
}
/*
 **************************************************************************
 *
 *   c_dospawn
 */
c_dospawn_(buf)
char buf[];
{
	system(buf);
}
/*
 *************************************************************************
 *
 *   c_getwd_()
*/
c_getwd_(buf)
char buf[];
{
	int i;

	if ((i = getwd(buf)) == NULL)
		return(-1);
	else
		return(0);
}
/*
 ************************************************************************
 *
 *   c_chdir_()
 */
c_chdir_(buf)
char buf[];
{
	int i;

	if ((i = chdir(buf)) != NULL)
		return(i);
	else
		return(0);
}
