      PROGRAM  diffird
c
c...Quickie Test Of ALPHA Port
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1*1000000
      INTEGER
     *         rold(NMAX), dold(NMAX), rnew(NMAX), dnew(NMAX), nn, i,
     *         dr, dd
      DOUBLE PRECISION
     *         x, y, sx, sy, sxx, syy, sn
c
 9001 FORMAT (i10)
c
c...Get Count
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uw0/xpmm/lists/sj0421a.inf',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nn
      CLOSE (1)
c
c...Read OLD Files
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uz6/xpmm/oldird/sj0421.ird',
     *      readonly,
     *      recl=nn,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (rold(i),i=1,nn)
      READ (1,rec=2) (dold(i),i=1,nn)
      CLOSE (1)
c
c...Read NEW Files
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='/uz6/xpmm/auxird/sj0421.ird',
     *      readonly,
     *      recl=nn,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (rnew(i),i=1,nn)
      READ (1,rec=2) (dnew(i),i=1,nn)
      CLOSE (1)
c
c...Do Something
c
      sx = 0.0D00
      sy = 0.0D00
      sxx = 0.0D00
      syy = 0.0D00
      sn = 0.0D00
      DO i=1,nn
        x = 0.01D00*(rnew(i)-rold(i))
        y = 0.01D00*(dnew(i)-dold(i))
        sx = sx + x
        sy = sy + y
        sxx = sxx + x*x
        syy = syy + y*y
        sn = sn + 1.0D00
      ENDDO
      sx = sx/sn
      sy = sy/sn
      sxx = SQRT(sxx/sn - sx*sx)
      syy = SQRT(syy/sn - sy*sy)
      write (*,9991) nn,sx,sxx,sy,syy
 9991 format (' N=', i10, '  X=', f6.2, '+/-', f5.2, '   Y=', f6.2,
     * '+/-', f5.2)
      CALL EXIT
      END
