      INTEGER SMALL0,SREGION
      CHARACTER*5 DUM
      COMMON/COM/NSTAR
C     Start GSC catalog -- extract Northern half
      NSTAR=0
c     TYPE *,'Insert and mount Northern CD rom, type <CR> to continue'
c     ACCEPT 98,DUM
98    FORMAT(A)
      OPEN(UNIT=10,NAME='gsc.dat',STATUS='NEW'
     1,ACCESS='DIRECT',RECL=16/4,CONVERT='BIG_ENDIAN')
      DO JLOOP=1,2
        IF(JLOOP.EQ.1) THEN
           N1=1
           N2=414
        ELSE
c          TYPE *,'Dismount Northern CD rom, insert and mount Southern'
c          ACCEPT 99,DUM
           N1=415
           N2=732
         ENDIF
         DO 5 JJ=N1,N2
            Type *,'Begin large region: ',jj
C           Large region JJ contains small regions SMALL0 thru SMALL0+K**2-1
            CALL SMALINX(JJ,SMALL0,K)
            DO 6 SREGION=SMALL0,SMALL0+K**2-1
C              Open the region on unit 1 and get number of stars and starting 
C              record
               CALL CDOPEN(SREGION,NUMSTR,NREC,jloop)
               CALL READDATA(NUMSTR,NREC,SREGION)
               CLOSE(UNIT=1)
	       write(15,99) jj,sregion,nstar
99	       format('large ',i5,' small ',i6,' total stars ',i8)
6           CONTINUE
5        CONTINUE
      ENDDO
      END
      SUBROUTINE CDOPEN(SREGION,NUMSTR,NREC,jloop)
      DIMENSION N1(25)
      CHARACTER*5 FOLNAM(24),FOLDER
      INTEGER SREGION
      CHARACTER*2880 line
      CHARACTER*80 OLINE
      CHARACTER*14 VOL
      CHARACTER*8 FNAME
C
C     Open the file associated with small region SREGION on UNIT=1
C     Return the number of stars and the starting record number of the data
C
      DATA N1/1,594,1178,1729,2259,2781,3246,3652,4014,4294,4492
     1,4615,4663,5260,5838,6412,6989,7523,8022,8464,8840,9134,9346
     1,9490,9538/
      DATA FOLNAM/'n0000','n0730','n1500','n2230','n3000','n3730'
     1,'n4500','n5230','n6000','n6730','n7500','n8230','s0000'
     1,'s0730','s1500','s2230','s3000','s3730','s4500','s5230'
     1,'s6000','s6730','s7500','s8230'/
      DATA FNAME/'    .gsc'/
      if (jloop.eq.1) then
        vol = '/uy6/cd/gsc11n'
      else
        vol = '/uy6/cd/gsc11s'
      endif
      DO 1 JJ=1,24
         IF(SREGION.GE.N1(JJ).AND.SREGION.LT.N1(JJ+1)) THEN
            FOLDER=FOLNAM(JJ)
            GO TO 2
         ENDIF
1     CONTINUE
      WRITE(15,9090) SREGION
9090  FORMAT('Bad small region number ',I10)
      STOP
2     CONTINUE
      WRITE(UNIT=FNAME(1:4),FMT=123) SREGION
123   FORMAT(I4.4)
      OPEN(UNIT=1,FILE=VOL//'/gsc/'//FOLDER//'/'//FNAME,
     1ACCESS='DIRECT',RECL=2880/4,STATUS='OLD',ERR=9999)
C     Read the extension FITS header and get the number of stars
C     Keep reading till the END to get starting record for data
      NN=2
1000  READ(1,REC=NN) LINE
      DO 15 JJ=1,36
        NL=(JJ-1)*80+1
        NH=NL+79
        OLINE=LINE(NL:NH)
        IF(OLINE(1:6).EQ.'NAXIS2') THEN
           READ(UNIT=OLINE(11:30),FMT=101) NUMSTR
101        FORMAT(I20)
        ELSEIF(OLINE(1:3).EQ.'END') THEN
C          Data starts in next record
           NREC=NN+1
           GO TO 5000
        ENDIF
15    CONTINUE
      NN=NN+1
      GO TO 1000
5000  RETURN
9999  IF(JJ.GE.14) THEN
         WRITE(6,3)
3        FORMAT(1X,'Please put in Southern CD and press return',$)
      ELSE
         WRITE(6,4)
4        FORMAT(1X,'Please put in Northern CD and press return',$)
      ENDIF
      READ(5,11) IDUM
11    FORMAT(I10)
      GO TO 2
      END
      SUBROUTINE SMALINX(LARGE,SMALL0,K)
      INTEGER SMALL0
      INTEGER SREG(732),IK(732)
C
C     Give large region LARGE, return the starting small region, SMALL0
C     and the size K.
C
      DATA (SREG(JJ),JJ=1,108)/
     1               1 ,  10 ,  19 ,  28 ,  37 ,  46 ,  55 ,  64 ,  73 ,  
     1  82 ,  98 , 114 , 130 , 146 , 162 , 178 , 194 , 210 , 226 , 235 ,
     1 244 , 253 , 262 , 271 , 280 , 289 , 298 , 307 , 316 , 325 , 334 ,
     1 350 , 366 , 382 , 398 , 414 , 430 , 446 , 462 , 478 , 494 , 510 ,
     1 526 , 542 , 558 , 567 , 576 , 585 , 594 , 603 , 612 , 621 , 630 ,
     1 639 , 648 , 657 , 666 , 682 , 698 , 714 , 730 , 746 , 762 , 778 ,
     1 794 , 810 , 819 , 828 , 837 , 846 , 855 , 864 , 873 , 882 , 891 ,
     1 900 , 909 , 918 , 927 , 943 , 959 , 975 , 991 ,1007 ,1023 ,1039 ,
     11055 ,1071 ,1087 ,1103 ,1119 ,1135 ,1151 ,1160 ,1169 ,1178 ,1187 ,
     11196 ,1205 ,1214 ,1223 ,1232 ,1248 ,1264 ,1280 ,1296 ,1312 ,1328/
      DATA (SREG(JJ),JJ=109,218)/
     11344 ,1360 ,1376 ,1392 ,1401 ,1410 ,1419 ,1428 ,1437 ,1441 ,1445 ,
     11449 ,1458 ,1467 ,1476 ,1485 ,1494 ,1503 ,1519 ,1535 ,1551 ,1567 ,
     11583 ,1599 ,1615 ,1631 ,1647 ,1663 ,1679 ,1695 ,1711 ,1720 ,1729 ,
     11738 ,1747 ,1756 ,1765 ,1781 ,1797 ,1813 ,1829 ,1845 ,1861 ,1877 ,
     11893 ,1909 ,1925 ,1941 ,1950 ,1959 ,1968 ,1977 ,1981 ,1985 ,1989 ,
     11993 ,1997 ,2006 ,2015 ,2024 ,2033 ,2042 ,2058 ,2074 ,2090 ,2106 ,
     12122 ,2138 ,2154 ,2170 ,2186 ,2202 ,2218 ,2234 ,2250 ,2259 ,2275 ,
     12291 ,2307 ,2323 ,2339 ,2355 ,2371 ,2387 ,2403 ,2419 ,2435 ,2451 ,
     12467 ,2483 ,2492 ,2501 ,2510 ,2519 ,2523 ,2527 ,2531 ,2535 ,2544 ,
     12553 ,2562 ,2571 ,2580 ,2589 ,2605 ,2621 ,2637 ,2653 ,2669 ,2685/
      DATA (SREG(JJ),JJ=219,328)/
     12701 ,2717 ,2733 ,2749 ,2765 ,2781 ,2797 ,2813 ,2829 ,2845 ,2861 ,
     12877 ,2893 ,2909 ,2925 ,2941 ,2957 ,2973 ,2982 ,2991 ,3000 ,3009 ,
     13013 ,3017 ,3021 ,3025 ,3034 ,3043 ,3052 ,3061 ,3070 ,3086 ,3102 ,
     13118 ,3134 ,3150 ,3166 ,3182 ,3198 ,3214 ,3230 ,3246 ,3262 ,3278 ,
     13294 ,3310 ,3326 ,3342 ,3358 ,3374 ,3390 ,3406 ,3415 ,3424 ,3433 ,
     13442 ,3451 ,3455 ,3459 ,3463 ,3472 ,3481 ,3490 ,3499 ,3508 ,3524 ,
     13540 ,3556 ,3572 ,3588 ,3604 ,3620 ,3636 ,3652 ,3668 ,3684 ,3700 ,
     13716 ,3732 ,3748 ,3764 ,3780 ,3796 ,3805 ,3814 ,3823 ,3832 ,3841 ,
     13850 ,3859 ,3868 ,3877 ,3886 ,3902 ,3918 ,3934 ,3950 ,3966 ,3982 ,
     13998 ,4014 ,4030 ,4046 ,4062 ,4078 ,4094 ,4110 ,4126 ,4135 ,4144/
      DATA (SREG(JJ),JJ=329,438)/
     14153 ,4162 ,4171 ,4180 ,4189 ,4198 ,4214 ,4230 ,4246 ,4262 ,4278 ,
     14294 ,4310 ,4326 ,4342 ,4358 ,4374 ,4383 ,4392 ,4401 ,4410 ,4419 ,
     14428 ,4444 ,4460 ,4476 ,4492 ,4508 ,4524 ,4540 ,4549 ,4558 ,4567 ,
     14583 ,4599 ,4615 ,4631 ,4647 ,4663 ,4672 ,4681 ,4685 ,4689 ,4698 ,
     14707 ,4716 ,4725 ,4734 ,4750 ,4766 ,4782 ,4798 ,4814 ,4830 ,4846 ,
     14862 ,4878 ,4894 ,4903 ,4912 ,4921 ,4930 ,4939 ,4948 ,4957 ,4966 ,
     14975 ,4984 ,5000 ,5016 ,5032 ,5048 ,5064 ,5080 ,5096 ,5112 ,5128 ,
     15144 ,5160 ,5176 ,5192 ,5208 ,5224 ,5233 ,5242 ,5251 ,5260 ,5269 ,
     15273 ,5277 ,5281 ,5285 ,5294 ,5303 ,5312 ,5321 ,5330 ,5346 ,5362 ,
     15378 ,5394 ,5410 ,5426 ,5442 ,5458 ,5474 ,5490 ,5499 ,5508 ,5517/
      DATA (SREG(JJ),JJ=439,548)/
     15526 ,5535 ,5544 ,5553 ,5562 ,5578 ,5594 ,5610 ,5626 ,5642 ,5658 ,
     15674 ,5690 ,5706 ,5722 ,5738 ,5754 ,5770 ,5786 ,5802 ,5811 ,5820 ,
     15829 ,5838 ,5847 ,5851 ,5855 ,5859 ,5863 ,5872 ,5881 ,5890 ,5899 ,
     15915 ,5931 ,5947 ,5963 ,5979 ,5995 ,6011 ,6027 ,6043 ,6059 ,6075 ,
     16084 ,6093 ,6102 ,6111 ,6120 ,6136 ,6152 ,6168 ,6184 ,6200 ,6216 ,
     16232 ,6248 ,6264 ,6280 ,6296 ,6312 ,6328 ,6344 ,6360 ,6376 ,6385 ,
     16394 ,6403 ,6412 ,6421 ,6425 ,6429 ,6433 ,6437 ,6446 ,6455 ,6464 ,
     16473 ,6489 ,6505 ,6521 ,6537 ,6553 ,6569 ,6585 ,6601 ,6617 ,6633 ,
     16649 ,6665 ,6681 ,6697 ,6713 ,6729 ,6745 ,6761 ,6777 ,6793 ,6809 ,
     16825 ,6841 ,6857 ,6873 ,6889 ,6905 ,6921 ,6937 ,6953 ,6962 ,6971/
      DATA (SREG(JJ),JJ=549,658)/
     16980 ,6989 ,6998 ,7002 ,7006 ,7010 ,7019 ,7028 ,7037 ,7046 ,7055 ,
     17071 ,7087 ,7103 ,7119 ,7135 ,7151 ,7167 ,7183 ,7199 ,7215 ,7231 ,
     17247 ,7263 ,7279 ,7295 ,7311 ,7327 ,7343 ,7359 ,7375 ,7391 ,7407 ,
     17423 ,7439 ,7455 ,7471 ,7487 ,7496 ,7505 ,7514 ,7523 ,7532 ,7541 ,
     17550 ,7559 ,7568 ,7577 ,7586 ,7595 ,7611 ,7627 ,7643 ,7659 ,7675 ,
     17691 ,7707 ,7723 ,7739 ,7755 ,7771 ,7787 ,7803 ,7819 ,7835 ,7851 ,
     17867 ,7883 ,7899 ,7915 ,7931 ,7947 ,7963 ,7979 ,7995 ,8004 ,8013 ,
     18022 ,8031 ,8040 ,8049 ,8058 ,8067 ,8076 ,8085 ,8101 ,8117 ,8133 ,
     18149 ,8165 ,8181 ,8197 ,8213 ,8229 ,8245 ,8261 ,8277 ,8293 ,8309 ,
     18325 ,8341 ,8357 ,8373 ,8389 ,8405 ,8421 ,8437 ,8446 ,8455 ,8464/
      DATA (SREG(JJ),JJ=659,732)/
     18473 ,8482 ,8491 ,8500 ,8509 ,8518 ,8534 ,8550 ,8566 ,8582 ,8598 ,
     18614 ,8630 ,8646 ,8662 ,8678 ,8694 ,8710 ,8726 ,8742 ,8758 ,8774 ,
     18790 ,8806 ,8822 ,8831 ,8840 ,8849 ,8858 ,8867 ,8876 ,8892 ,8908 ,
     18924 ,8940 ,8956 ,8972 ,8988 ,9004 ,9020 ,9036 ,9052 ,9068 ,9084 ,
     19100 ,9116 ,9125 ,9134 ,9143 ,9152 ,9161 ,9177 ,9193 ,9209 ,9225 ,
     19241 ,9257 ,9273 ,9289 ,9305 ,9321 ,9337 ,9346 ,9362 ,9378 ,9394 ,
     19410 ,9426 ,9442 ,9458 ,9474 ,9490 ,9506 ,9522 /                  
      DATA (IK(JJ),JJ=1,127)/
     1          3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,
     13,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,
     14,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,
     13,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,3,3,3,3,3,3,4,4/
      DATA(IK(JJ),JJ=128,259)/
     14,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,2,
     12,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,4,4,4,4,4,4,4,4,
     14,4,4,4,3,3,3,3,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     14,4,4,4,4,4,4,4,4,3,3,3,3,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4/
      DATA (IK(JJ),JJ=260,391)/
     14,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,
     14,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     13,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,4,4,4,4,4,4,4,3,
     13,3,4,4,4,4,4,4,3,3,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3/
      DATA(IK(JJ),JJ=392,523)/
     13,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,3,3,3,3,3,
     14,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     13,3,3,3,3,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,4,4,4,4,
     14,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,4/
      DATA(IK(JJ),JJ=524,655)/
     14,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,3,3,3,
     13,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,
     13,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     13,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3/
      DATA (IK(JJ),JJ=656,732)/
     13,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,
     14,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,3,4,
     14,4,4,4,4,4,4,4,4,4,4/                                            
C
      SMALL0=SREG(LARGE)
      K=IK(LARGE)
      RETURN
      END
      SUBROUTINE READDATA(NUMSTR,NREC,SREGION)
      REAL*8 RAA,DECC,RAS,DECS
      INTEGER*4 IVM,JVM,JCODE,JDOLD
      INTEGER*4 IRA,IDEC,JRA,JDEC
      CHARACTER*2880 LINE
      CHARACTER*4 CODE,CODEOLD
      CHARACTER*45 DATA
      CHARACTER*8 IDOLD
      CHARACTER*8 ID
      INTEGER SREGION
      COMMON/COM/NSTAR
C     Read the stars from the file open on UNIT=1 and write out if they
C     lie within the plate
C     Read data records until NUMSTR stars have been found
C     
      ID=' '
      WRITE(UNIT=ID(1:4),FMT=808) SREGION
808   FORMAT(I4)
      NR=NREC
      OPEN(UNIT=21,STATUS='SCRATCH',ACCESS='DIRECT',RECL=32/4)
9999  NCT=0
      NS=0
3000  READ(1,REC=NR) LINE
      DO 2 JJ=1,64
        N1=(JJ-1)*45+1
        N2=N1+44
        NCT=NCT+1
        DATA=LINE(N1:N2)
        READ(UNIT=DATA(29:33),FMT=198) VMAG
198     FORMAT(F5.2)
C       Convert RA and Dec (in deg)
        READ(UNIT=DATA(6:14),FMT=199) RAA
199     FORMAT(F9.5)
        READ(UNIT=DATA(15:23),FMT=199) DECC
        NS=NS+1
        ID(5:8)=DATA(2:5)
        IF(DATA(1:1).NE.'0') THEN
            WRITE(15,8080) SREGION,DATA
8080        FORMAT('ERROR ',I4,2X,A)
            TYPE *,'ERROR',SREGION,DATA
        ENDIF
	IF(DATA(40:40).EQ.'0') THEN
           CODE='Y'
	ELSE
           CODE='N'
        ENDIF
	WRITE(21'NS) ID,RAA,DECC,VMAG,CODE
102     IF(NCT.EQ.NUMSTR) GO TO 4000
2     CONTINUE
      NR=NR+1
      GO TO 3000
C---  Compress out duplicates
4000  READ(21'1) IDOLD,RAS,DECS,VMS,CODEOLD
      IF(NS.EQ.1) THEN
          NSTAR=NSTAR+1
          IRA=NINT(RAS*1000000)
          IDEC=NINT(DECS*1000000)
          IVM=NINT(VMS*100)
      read (idold,9991) jdold
      jra = ras*360000.0D00
      jdec = (decs+90.0D00)*360000.0D00
      jvm = 10000*ICHAR(codeold(1:1)) + ivm
 9991 format (i8)
          WRITE(10'NSTAR) JDOLD,JRA,JDEC,JVM
      ELSE
         ND=1
         DO JJ=2,NS
            READ(21'JJ) ID,RAA,DECC,VMAG,CODE
            IF(ID.EQ.IDOLD) THEN
               ND=ND+1
               RAS=RAS+RAA
               DECS=DECS+DECC
               VMS=VMS+VMAG
            ELSE
	       RAS=RAS/ND
	       DECS=DECS/ND
	       VMS=VMS/ND
	       NSTAR=NSTAR+1
               IRA=NINT(RAS*1000000)
               IDEC=NINT(DECS*1000000)
               IVM=NINT(VMS*100)
      read (idold,9991) jdold
      jra = ras*360000.0D00
      jdec = (decs+90.0D00)*360000.0D00
      jvm = 10000*ICHAR(codeold(1:1)) + ivm
               WRITE(10'NSTAR) JDOLD,JRA,JDEC,JVM
               ND=1
               RAS=RAA
	       DECS=DECC
	       VMS=VMAG
	       IDOLD=ID
	       CODEOLD=CODE
	     ENDIF
         ENDDO
         RAS=RAS/ND
         DECS=DECS/ND
         VMS=VMS/ND
         IRA=NINT(RAS*1000000)
         IDEC=NINT(DECS*1000000)
         IVM=NINT(VMS*100)
         NSTAR=NSTAR+1
      read (idold,9991) jdold
      jra = ras*360000.0D00
      jdec = (decs+90.0D00)*360000.0D00
      jvm = 10000*ICHAR(codeold(1:1)) + ivm
         WRITE(10'NSTAR) JDOLD,JRA,JDEC,JVM
      ENDIF
      CLOSE(UNIT=21)
      RETURN
      END
