      SUBROUTINE  slasetup(emul,p1ra,p1dec,p1djm,p1ut)
c
c...Set Up SLALIB For Xi,Eta Conversion
c
      INCLUDE
     *            'slalib.inc'
      DOUBLE PRECISION
     *             djm, oaz, ozd, oha, p1ra, p1dec, p1djm, p1ut,
     *             ara, adec, ora, odec, xi, eta
      INTEGER
     *            j
      CHARACTER*(*)
     *            emul
c
c...Define Parameters
c
  100 field_epoch = 2000.0D00
      obs_scale = 67.18D00
      radian = 45.0D00/ATAN(1.0D00)
      CALL sla_MAPPA(field_epoch,p1djm,amprms)
      mid_exp = p1djm + p1ut/24.0D00
      obs_long = -(116.0D00 + 51.8D00/60.0D00)/radian
      obs_lat = (33.0D00 + 21.4D00/60.0D00)/radian
      obs_elev = 1706.0D00
      obs_temp = 285.0D00
      obs_pres = 1013.25D00*EXP(-obs_elev/8149.9415D00)
      obs_humid = 0.25D00
      obs_emul = 256*ICHAR(emul(1:1)) + ICHAR(emul(2:2))
      IF ((emul.eq.'UJ').or.(emul.eq.'SJ')) THEN
        obs_wave = 0.48D00
      ELSEIF (emul.eq.'SF') THEN
        obs_wave = 0.65D00
      ELSEIF (emul.eq.'SN') THEN
        obs_wave = 0.85D00
      ELSEIF (emul.eq.'SO') THEN
        obs_wave = 0.41D00
      ELSEIF (emul.eq.'SE') THEN
        obs_wave = 0.65D00
      ELSE
        STOP 'EMULSION'
      ENDIF
      obs_tlr = 0.0065D00
      obs_tlr = 0.0065D00
      obs_xpolar = 0.0D00
      obs_ypolar = 0.0D00
      obs_dut = 0.0D00
      CALL sla_AOPPA(mid_exp, obs_dut, obs_long, obs_lat, obs_elev,
     *               obs_xpolar, obs_ypolar, obs_temp, obs_pres,
     *               obs_humid, obs_wave, obs_tlr, aoprms)
c
c...Transform The Field Center
c
      CALL sla_MAPQKZ(p1ra,p1dec,amprms,field_ara,field_adec)
      CALL sla_AOPQK(field_ara,field_adec,aoprms,oaz,ozd,oha,
     *                field_odec,field_ora)
      obs_unit = 3600.0D00*100000.0D00*radian/obs_scale
      obs_disco = -0.3333D00
      RETURN
      END
