      PROGRAM  genlut
c
c...Get The POSS-I Plate Corners
c
      INCLUDE
     *            'genlut.inc'
      INTEGER
     *            i, id, r, d, ir, n, j
      DOUBLE PRECISION
     *            rhh, rmm, rss, ddd, dmm, dss, r1950, d1950,
     *            r2000, d2000, ra_to_rad, dec_to_rad,
     *            r0, d0, z, rulc, dulc, rurc, durc, rllc, dllc
      CHARACTER*1
     *            dsign
c
 9001 FORMAT (i6, 23x, 3f2.0, 1x, a, 3f2.0)
c
c...Initialization
c
  100 radian = 45.0D00/ATAN(1.0D00)
      ra_to_rad = 15.0D00/radian
      dec_to_rad = 1.0D00/radian
c
c...Read Nominals.  These Are B1950
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      DO i=1,NP1
        READ (1,9001) id,rhh,rmm,rss,dsign,ddd,dmm,dss
        READ (1,9001)
        IF (id.ne.i) THEN
          STOP 'POSS-I Out Of Order'
        ENDIF
        d1950 = (ddd + dmm/60.0D00 + dss/3600.0D00)*dec_to_rad
        IF (dsign.eq.'+') THEN
          CONTINUE
        ELSEIF (dsign.eq.'-') THEN
          d1950 = -d1950
        ELSE
          STOP 'POSS-I DEC Parse Error'
        ENDIF
        r1950 = (rhh + rmm/60.0D00 + rss/3600.0D00)*ra_to_rad
        CALL sla_FK45Z(r1950,d1950,1950.0D00,r2000,d2000)
        p1ra(i) = r2000
        p1dec(i) = d2000
      ENDDO
      CLOSE (1)
c
c...Compute Corners
c
      DO i=1,NP1
        r0 = p1ra(i)
        d0 = p1dec(i)
        z = (WIDE*SCALE/3600.0D00)/radian
        CALL sla_DTP2S(-z,-z,r0,d0,rllc,dllc)
        CALL sla_DTP2S(-z, z,r0,d0,rulc,dulc)
        CALL sla_DTP2S( z, z,r0,d0,rurc,durc)
        rstart(i) = radian*rulc
        rstop(i)  = radian*rurc + 0.999D00
        IF ((rstart(i)-rstop(i)).gt.180) THEN
          rmode(i) = 1
        ELSE
          rmode(i) = 0
        ENDIF
        dstart(i) = radian*dllc
        dstop(i)  = radian*dulc + 0.999D00
c     write (*,9992) r0,d0,rstart(i),rstop(i),dstart(i),dstop(i)
c     if (mod(i,10).eq.0) pause
 9992 format (2f10.6, 4i10)
c
c...Patches
c
        IF (i.le.2) THEN
          rstart(i) = 0
          rstop(i) = NRA-1
          dstart(i) = 85
          dstop(i) = NDEC-1
        ELSE
          dstart(i) = MAX(dstart(i),0)
        ENDIF
      ENDDO
c
c...Fill The Look-Up Table
c
      DO d=0,NDEC-1
        DO r=0,NRA-1
          nlut(r,d) = 0
        ENDDO
      ENDDO
      DO i=1,NP1
        IF (rmode(i).eq.0) THEN
          DO d=dstart(i),dstop(i)
            DO r=rstart(i),rstop(i)
              n = nlut(r,d)+1
              nlut(r,d) = n
              lut(r,d,n) = i
            ENDDO
          ENDDO
        ELSE
          DO d=dstart(i),dstop(i)
            DO r=rstart(i),NRA-1
              n = nlut(r,d)+1
              nlut(r,d) = n
              lut(r,d,n) = i
            ENDDO
            DO r=0,rstop(i)
              n = nlut(r,d)+1
              nlut(r,d) = n
              lut(r,d,n) = i
            ENDDO
          ENDDO
        ENDIF
      ENDDO
c
c...Inhale The GSC
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      dispose='keep',
     *      form='unformatted',
     *      name='gsc.dat',
     *      readonly,
     *      recl=(6*NGSC),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) gscbuf
      CLOSE (1)
      do i=1,10
      r0 = gscbuf(3,i)*0.000001D00
      d0 = gscbuf(4,i)*0.000001D00
      write (*,9991) (gscbuf(j,i),j=1,6),r0,d0
      enddo
 9991 format (2a4, 3i10, a4, 2f10.6)
      CALL EXIT
      END
