      SUBROUTINE  p1lut
c
c...Get The POSS-I Plate Corners And Fill LookUp Table
c
      INCLUDE
     *            'possgsc.inc'
      INTEGER
     *            i, id, r, d, ir, n, j
      DOUBLE PRECISION
     *            rhh, rmm, rss, ddd, dmm, dss, r1950, d1950,
     *            r2000, d2000, ra_to_rad, dec_to_rad,
     *            r0, d0, z, rulc, dulc, rurc, durc, rllc, dllc,
     *            rlrc, dlrc, rct, dct, rcb, dcb
      CHARACTER*1
     *            dsign
c
 9001 FORMAT (i6, 23x, 3f2.0, 1x, a, 3f2.0)
 9002 FORMAT (6i6, 2f10.7)
c
c...Initialization
c
  100 radian = 45.0D00/ATAN(1.0D00)
      ra_to_rad = 15.0D00/radian
      dec_to_rad = 1.0D00/radian
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='gsc.info',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Read Nominals.  These Are B1950
c
      CALL p1read
c
c...Compute Corners
c
      DO i=1,NP1
        r0 = p1ra(i)
        d0 = p1dec(i)
        z = (WIDE*SCALE/3600.0D00)/radian
        CALL sla_DTP2S(-z,-z,r0,d0,rllc,dllc)
        CALL sla_DTP2S( z,-z,r0,d0,rlrc,dlrc)
        CALL sla_DTP2S(-z, z,r0,d0,rulc,dulc)
        CALL sla_DTP2S( z, z,r0,d0,rurc,durc)
        IF (d0.lt.0.0D00) THEN
          rstart(i) = radian*rllc
          rstop(i)  = radian*rlrc + 0.999D00
        ELSE
          rstart(i) = radian*rulc
          rstop(i)  = radian*rurc + 0.999D00
        ENDIF
        IF ((rstart(i)-rstop(i)).gt.180) THEN
          rmode(i) = 1
        ELSE
          rmode(i) = 0
        ENDIF
        CALL sla_DTP2S(0.0D00,-z,r0,d0,rcb,dcb)
        CALL sla_DTP2S(0.0D00, z,r0,d0,rct,dct)
        dstart(i) = radian*dcb
        dstop(i)  = radian*dct + 0.999D00
c
c...Patches
c
        IF (i.le.2) THEN
          rstart(i) = 0
          rstop(i) = 359
          dstart(i) = 85
          dstop(i) = 89
        ENDIF
        WRITE (2,9002) i,rstart(i),rstop(i),dstart(i),dstop(i),
     *                 rmode(i),p1ra(i),p1dec(i)
      ENDDO
c
c...Fill The Look-Up Table
c
      CLOSE (2)
      DO d=-89,89
        DO r=0,359
          nlut(r,d) = 0
        ENDDO
      ENDDO
      DO i=1,NP1
        IF (rmode(i).eq.0) THEN
          DO d=dstart(i),dstop(i)
            DO r=rstart(i),rstop(i)
              n = nlut(r,d)+1
              nlut(r,d) = n
              lut(r,d,n) = i
            ENDDO
          ENDDO
        ELSE
          DO d=dstart(i),dstop(i)
            DO r=rstart(i),359
              n = nlut(r,d)+1
              nlut(r,d) = n
              lut(r,d,n) = i
            ENDDO
            DO r=0,rstop(i)
              n = nlut(r,d)+1
              nlut(r,d) = n
              lut(r,d,n) = i
            ENDDO
          ENDDO
        ENDIF
      ENDDO
      RETURN
      END
