      PROGRAM  checkback
c
c...Check Backup Tape Status With DIR.LIS
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nfmax = 1000,
     *         nvmax = 10,
     *         nlog = 21
      INTEGER
     *         uj(NFMAX), so(NVMAX,NFMAX), se(NVMAX,NFMAX),
     *         sj(NVMAX,NFMAX), sf(NVMAX,NFMAX), sn(NVMAX,NFMAX),
     *         f, v, nlb, tag, l, nu, no, ne, nj, nf, nn
      CHARACTER*1
     *         cv
      CHARACTER*3
     *         type
      CHARACTER*3
     *         log(NLOG)
      CHARACTER*4
     *         cf
      CHARACTER*2
     *         survey
      CHARACTER*64
     *         lb
      DATA
     *   log/'a0e', 'a0o', 'a1e', 'a1o', 'c0a', 'c0b', 'c1a', 'c1b',
     *       'g0a', 'g0b', 'g1a', 'g1b', 'w0e', 'w0o', 'w1e', 'w1o',
     *       'x0x', 'x1x', 'bbk', 'cbk', 'dbk'/
c
 9001 FORMAT (q, a)
 9002 FORMAT (' Unknown Survey >>', a, '<<')
 9003 FORMAT (' Illegal Field >>', a, '<<')
 9004 FORMAT (' Illegal Version >>', a, '<<')
 9005 FORMAT (i4)
 9006 FORMAT (' Missing Pieces: ', a, i4.4, a, i10)
 9007 FORMAT (' Parse Error >>', a, '<<')
 9008 FORMAT (' Read DIR.LIS', i10)
 9009 FORMAT (' Finished Check of DIR.LIS')
 9010 FORMAT (' Processing 8mm Backups')
 9011 FORMAT (' Found More Than Once ', a, i4.4, a, i10)
 9012 FORMAT (' Backed Up More Than Once ', a, i4.4, a, i10)
 9013 FORMAT (' Not Backed Up ', a, i4.4, a, i10)
 9014 FORMAT (' NU=', i4, '  NO=', i4, '  NE=', i4, '  NJ=', i4,
     *        '  NF=', i4, '  NN=', i4)
c
c...Initialization
c
  100 DO f=1,NFMAX
        uj(f) = 0
        DO v=1,NVMAX
          so(v,f) = 0
          se(v,f) = 0
          sj(v,f) = 0
          sf(v,f) = 0
          sn(v,f) = 0
        ENDDO
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='checkback.out',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Read DIR.LIS And Mark Each Entry
c
c     CALL system('gendir')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='dir.lis',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) nlb,lb
      IF (nlb.le.10) GO TO 110
      survey = lb(nlb-10:nlb-9)
      cf = lb(nlb-8:nlb-5)
      cv = lb(nlb-4:nlb-4)
      type = lb(nlb-2:nlb)
      IF (type.eq.'inf') THEN
        tag = 1
      ELSEIF (type.eq.'hdr') THEN
        tag = 2
      ELSEIF (type.eq.'dat') THEN
        tag = 4
      ELSE
        GO TO 110
      ENDIF
      v = 1 + ICHAR(cv) - ICHAR('a')
      IF ((v.le.0).or.(v.gt.NVMAX)) THEN
        READ  (cf,9005,err=110) f
        WRITE (*,9004) lb(1:nlb)
        GO TO 110
      ENDIF
      READ (cf,9005,err=200) f
      IF ((f.le.0).or.(f.gt.NFMAX)) THEN
        IF (f.ge.9000) GO TO 110
        WRITE (*,9003) lb(1:nlb)
        GO TO 110
      ENDIF
      IF (survey.eq.'uj') THEN
        uj(f) = uj(f)+tag
      ELSEIF (survey.eq.'so') THEN
        so(v,f) = so(v,f)+tag
      ELSEIF (survey.eq.'se') THEN
        se(v,f) = se(v,f)+tag
      ELSEIF (survey.eq.'sj') THEN
        sj(v,f) = sj(v,f)+tag
      ELSEIF (survey.eq.'sf') THEN
        sf(v,f) = sf(v,f)+tag
      ELSEIF (survey.eq.'sn') THEN
        sn(v,f) = sn(v,f)+tag
      ENDIF
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9008)
c
c...Count To Reassure User
c
      nu = 0
      no = 0
      ne = 0
      nj = 0
      nf = 0
      nn = 0
      DO f=1,NFMAX
        IF (uj(f).ne.0) nu = nu+1
        IF (so(1,f).ne.0) no = no+1
        IF (se(1,f).ne.0) ne = ne+1
        IF (sj(1,f).ne.0) nj = nj+1
        IF (sf(1,f).ne.0) nf = nf+1
        IF (sn(1,f).ne.0) nn = nn+1
      ENDDO
      WRITE (*,9014) nu,no,ne,nj,nf,nn
c
c...Verify That All Files Are Complete
c
      DO f=1,NFMAX
        IF ((uj(f).ne.0).and.(uj(f).ne.7)) THEN
          survey = 'uj'
          cf = 'a'
          IF (uj(f).lt.7) THEN
            WRITE (*,9006) survey,f,cv,uj(f)
            WRITE (2,9006) survey,f,cv,uj(f)
          ELSE
            WRITE (*,9011) survey,f,cv,uj(f)
            WRITE (2,9011) survey,f,cv,uj(f)
          ENDIF
        ENDIF
        DO v=1,NVMAX
          IF ((so(v,f).ne.0).and.(so(v,f).ne.7)) THEN
            survey = 'so'
            cv = CHAR(ICHAR('a')+v-1)
            IF (so(v,f).lt.7) THEN
              WRITE (*,9006) survey,f,cv,so(v,f)
              WRITE (2,9006) survey,f,cv,so(v,f)
            ELSE
              WRITE (*,9011) survey,f,cv,so(v,f)
              WRITE (2,9011) survey,f,cv,so(v,f)
            ENDIF
          ENDIF
          IF ((se(v,f).ne.0).and.(se(v,f).ne.7)) THEN
            survey = 'se'
            cv = CHAR(ICHAR('a')+v-1)
            IF (se(v,f).lt.7) THEN
              WRITE (*,9006) survey,f,cv,se(v,f)
              WRITE (2,9006) survey,f,cv,se(v,f)
            ELSE
              WRITE (*,9011) survey,f,cv,se(v,f)
              WRITE (2,9011) survey,f,cv,se(v,f)
            ENDIF
          ENDIF
          IF ((sj(v,f).ne.0).and.(sj(v,f).ne.7)) THEN
            survey = 'sf'
            cv = CHAR(ICHAR('a')+v-1)
            IF (sj(v,f).lt.7) THEN
              WRITE (*,9006) survey,f,cv,sj(v,f)
              WRITE (2,9006) survey,f,cv,sj(v,f)
            ELSE
              WRITE (*,9011) survey,f,cv,sj(v,f)
              WRITE (2,9011) survey,f,cv,sj(v,f)
            ENDIF
          ENDIF
          IF ((sf(v,f).ne.0).and.(sf(v,f).ne.7)) THEN
            survey = 'sf'
            cv = CHAR(ICHAR('a')+v-1)
            IF (sf(v,f).lt.7) THEN
              WRITE (*,9006) survey,f,cv,sf(v,f)
              WRITE (2,9006) survey,f,cv,sf(v,f)
            ELSE
              WRITE (*,9011) survey,f,cv,sf(v,f)
              WRITE (2,9011) survey,f,cv,sf(v,f)
            ENDIF
          ENDIF
          IF ((sn(v,f).ne.0).and.(sn(v,f).ne.7)) THEN
            survey = 'sn'
            cv = CHAR(ICHAR('a')+v-1)
            IF (sn(v,f).lt.7) THEN
              WRITE (*,9006) survey,f,cv,sn(v,f)
              WRITE (2,9006) survey,f,cv,sn(v,f)
            ELSE
              WRITE (*,9011) survey,f,cv,sn(v,f)
              WRITE (2,9011) survey,f,cv,sn(v,f)
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      WRITE (*,9009)
c
c...Process Each Of The 8mm Logs
c
      WRITE (*,9010)
      DO l=1,NLOG
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='/uy6/xpmm/8mmlog/'//log(l),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
  130   READ (1,9001,end=140) nlb,lb
        IF (nlb.le.10) GO TO 130
        survey = lb(nlb-10:nlb-9)
        cf = lb(nlb-8:nlb-5)
        cv = lb(nlb-4:nlb-4)
        type = lb(nlb-2:nlb)
        IF (type.eq.'inf') THEN
          tag = 1
        ELSEIF (type.eq.'hdr') THEN
          tag = 2
        ELSEIF (type.eq.'dat') THEN
          tag = 4
        ELSE
          GO TO 130
        ENDIF
        v = 1 + ICHAR(cv) - ICHAR('a')
        IF ((v.le.0).or.(v.gt.NVMAX)) GO TO 130
        READ (cf,9005,err=130) f
        IF ((f.le.0).or.(f.gt.NFMAX)) GO TO 130
        IF (survey.eq.'uj') THEN
          uj(f) = uj(f)-tag
        ELSEIF (survey.eq.'so') THEN
          so(v,f) = so(v,f)-tag
        ELSEIF (survey.eq.'se') THEN
          se(v,f) = se(v,f)-tag
        ELSEIF (survey.eq.'sj') THEN
          sj(v,f) = sj(v,f)-tag
        ELSEIF (survey.eq.'sf') THEN
          sf(v,f) = sf(v,f)-tag
        ELSEIF (survey.eq.'sn') THEN
          sn(v,f) = sn(v,f)-tag
        ELSE
          GO TO 130
        ENDIF
        GO TO 130
  140   CLOSE (1)
      ENDDO
c
c...Count To Alert User
c
      nu = 0
      no = 0
      ne = 0
      nj = 0
      nf = 0
      nn = 0
      DO f=1,NFMAX
        IF (uj(f).ne.0) nu = nu+1
        IF (so(1,f).ne.0) no = no+1
        IF (se(1,f).ne.0) ne = ne+1
        IF (sj(1,f).ne.0) nj = nj+1
        IF (sf(1,f).ne.0) nf = nf+1
        IF (sn(1,f).ne.0) nn = nn+1
      ENDDO
      WRITE (*,9014) nu,no,ne,nj,nf,nn
c
c...See If All Is Well
c
      DO f=1,NFMAX
        IF (uj(f).ne.0) THEN
          survey = 'uj'
          cv = 'a'
          IF (uj(f).lt.0) THEN
c           WRITE (*,9012) survey,f,cv,uj(f)
            WRITE (2,9012) survey,f,cv,uj(f)
          ELSE
            WRITE (*,9013) survey,f,cv,uj(f)
            WRITE (2,9013) survey,f,cv,uj(f)
          ENDIF
        ENDIF
        DO v=1,NVMAX
          IF (so(v,f).ne.0) THEN
            survey = 'so'
            cv = CHAR(ICHAR('a')+v-1)
            IF (so(v,f).lt.0) THEN
c             WRITE (*,9012) survey,f,cv,so(v,f)
              WRITE (2,9012) survey,f,cv,so(v,f)
            ELSE
              WRITE (*,9013) survey,f,cv,so(v,f)
              WRITE (2,9013) survey,f,cv,so(v,f)
            ENDIF
          ENDIF
          IF (se(v,f).ne.0) THEN
            survey = 'se'
            cv = CHAR(ICHAR('a')+v-1)
            IF (se(v,f).lt.0) THEN
c             WRITE (*,9012) survey,f,cv,se(v,f)
              WRITE (2,9012) survey,f,cv,se(v,f)
            ELSE
              WRITE (*,9013) survey,f,cv,se(v,f)
              WRITE (2,9013) survey,f,cv,se(v,f)
            ENDIF
          ENDIF
          IF (sj(v,f).ne.0) THEN
            survey = 'sj'
            cv = CHAR(ICHAR('a')+v-1)
            IF (sj(v,f).lt.0) THEN
c             WRITE (*,9012) survey,f,cv,sj(v,f)
              WRITE (2,9012) survey,f,cv,sj(v,f)
            ELSE
              WRITE (*,9013) survey,f,cv,sj(v,f)
              WRITE (2,9013) survey,f,cv,sj(v,f)
            ENDIF
          ENDIF
          IF (sf(v,f).ne.0) THEN
            survey = 'sf'
            cv = CHAR(ICHAR('a')+v-1)
            IF (sf(v,f).lt.0) THEN
c             WRITE (*,9012) survey,f,cv,sf(v,f)
              WRITE (2,9012) survey,f,cv,sf(v,f)
            ELSE
              WRITE (*,9013) survey,f,cv,sf(v,f)
              WRITE (2,9013) survey,f,cv,sf(v,f)
            ENDIF
          ENDIF
          IF (sn(v,f).ne.0) THEN
            survey = 'sn'
            cv = CHAR(ICHAR('a')+v-1)
            IF (sn(v,f).lt.0) THEN
c             WRITE (*,9012) survey,f,cv,sn(v,f)
              WRITE (2,9012) survey,f,cv,sn(v,f)
            ELSE
              WRITE (*,9013) survey,f,cv,sn(v,f)
              WRITE (2,9013) survey,f,cv,sn(v,f)
            ENDIF
          ENDIF
        ENDDO
      ENDDO
c
c...All Done
c
      CLOSE (2)
      CALL EXIT
c
c...Other Errors
c
  200 WRITE (*,9007) lb(1:nlb)
      GO TO 110
      END
