      SUBROUTINE  postcurf(iter,nel,elnew,chnew,chold,sgnew,istat)
c
c...Bevington's CURFIT
c
      INCLUDE
     *            'postanal.inc'
      PARAMETER
     *            nplim = 3
      DOUBLE PRECISION
     *            elnew(*), chnew, chold, sgnew(*), elold(NMMAX),
     *            sgold(NMMAX), flamd, z, stnew, stold, beold(NMMAX),
     *            alold(NMMAX,NMMAX), alnew(NMMAX,NMMAX),
     *            array(NMMAX,NMMAX), benew(NMMAX)
      INTEGER
     *            iter, istat, npoor, i, j, k, nel
c
c..Special Logic For First Iteration
c
  100 npoor = 0
      IF (iter.eq.1) THEN
        flamd = 1.0D00
        DO j=1,nel
          sgnew(j) = 0.0D00
        ENDDO
        CALL postdcalc(nel,elnew,alnew,benew,chnew,stnew,istat)
        IF (istat.ne.0) RETURN
      ENDIF
c
c...Save Current Parameters
c
      chold = chnew
      stold = stnew
      DO j=1,nel
        elold(j) = elnew(j)
        sgold(j) = sgnew(j)
        beold(j) = benew(j)
        DO k=1,nel
          alold(j,k) = alnew(j,k)
        ENDDO
      ENDDO
c
c...Process Using Previously Filled ALPHA Array
c
  120 DO j=1,nel
        IF (alnew(j,j).eq.0.0) THEN
          istat = -99
          RETURN
        ENDIF
      ENDDO
      DO j=1,nel
        DO k=1,nel
          array(j,k) = alnew(j,k)/SQRT(alnew(j,j)*alnew(k,k))
        ENDDO
         array(j,j) = 1.0+flamd
      ENDDO
c
c...Invert The Matrix
c
      CALL postmatinv(nel,array,istat)
      IF (istat.ne.0) RETURN
c
c...Compute New Elements
c
      DO j=1,nel
        DO k=1,nel
          elnew(j) = elnew(j)
     *             + benew(k)*array(j,k)/SQRT(alnew(j,j)*alnew(k,k))
        ENDDO
      ENDDO
c
c...Compute Current Chi-Squared And Next ALPHA and BETA
c
      CALL postdcalc(nel,elnew,alnew,benew,chnew,stnew,istat)
      IF (istat.ne.0) RETURN
      DO j=1,nel
        sgnew(j) = stnew*SQRT(ABS(array(j,j)/alnew(j,j)))
      ENDDO
c
c...Process If Things Got Better Or Worse
c
      IF (chnew.le.chold) THEN
        flamd = flamd*0.1
        istat = 0
      ELSE
        npoor = npoor+1
        flamd = flamd*3.0
        chnew = chold
        stnew = stold
        DO j=1,nel
          elnew(j) = elold(j)
          sgnew(j) = sgold(j)
          benew(j) = beold(j)
          DO k=1,nel
            alnew(j,k) = alold(j,k)
          ENDDO
        ENDDO
        IF (npoor.le.NPLIM) GO TO 120
        istat = 1
      ENDIF
      RETURN
      END
