      SUBROUTINE  postdcalc(nel,param,alpha,beta,chisq,sigma,istat)
c
c...Compute ALPHA And BETA Arrays
c
      INCLUDE
     *            'postanal.inc'
      DOUBLE PRECISION
     *            param(*), alpha(NMMAX,NMMAX), beta(*), chisq,
     *            sigma, la, lb, ha, hb, c, d, e, fx, gy, a, b,
     *            df(NMMAX), f, dfda, dfdb, r
      INTEGER
     *            nel, lowlim, highlim, istat, i, j, k, x, y, nin, m
c
c...Initialization
c
  100 DO i=1,nel
        beta(i) = 0.0D00
        DO j=1,nel
          alpha(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      la = param(1)
      lb = param(2)
      ha = param(3)
      hb = param(4)
      c  = param(5)
      d  = param(6)
      e  = param(7)
      lowlim  = param(8)+0.5D00
      highlim = param(9)+0.5D00
      IF (nel.ne.7) THEN
        STOP 'Illegal Call To POSTDCALC'
      ENDIF
c
c...Evaluate
c
      nin = 0
      DO x=1,NXBIN
        IF (x.le.lowlim) THEN
          a = la
          b = lb
          m = 1
        ELSEIF (x.ge.highlim) THEN
          a = ha
          b = hb
          m = 3
        ELSE
          m = 0
        ENDIF
        IF (m.gt.0) THEN
          fx = EXP(a+b*x)
          dfda = fx
          dfdb = fx*x
          DO y=1,NYBIN
            IF (sx(x,y).gt.0.0D00) THEN
              gy = c + d*y + e*y*y
              f = fx*gy
              IF (m.eq.1) THEN
                df(1) = gy*dfda
                df(2) = gy*dfdb
                df(3) = 0.0D00
                df(4) = 0.0D00
              ELSE
                df(1) = 0.0D00
                df(2) = 0.0D00
                df(3) = gy*dfda
                df(4) = gy*dfdb
              ENDIF
              df(5) = fx
              df(6) = fx*y
              df(7) = fx*y*y
              r = sx(x,y)-f
              chisq = chisq + r*r
              nin = nin+1
              DO j=1,nel
                beta(j) = beta(j) + r*df(j)
                DO k=1,nel
                  alpha(j,k) = alpha(j,k) + df(j)*df(k)
                ENDDO
              ENDDO
            ENDIF
          ENDDO
        ENDIF
      ENDDO
c
c...Make Sure There Are Enough Points
c
      IF (nin.le.(nel+1)) THEN
        istat = -1
      ELSE
        sigma = SQRT(chisq/(nin-(nel+1)))
        istat = 0
      ENDIF
      RETURN
      END
