      SUBROUTINE  postsum(root)
c
c...Ingest All Of The FAKE Pairs
c
      INCLUDE
     *            'postanal.inc'
      CHARACTER*(*)
     *            root
      CHARACTER*64
     *            lb
      INTEGER
     *            nroot, nlb, i, j, k, x, y, jf, count
      REAL
     *            z, histadd
c
 9001 FORMAT (a, i2.2, '.dat')
 9004 FORMAT (' NFake=', i2, '  NPair=', i7, '  NIn=', i7)
 9005 FORMAT (' Recovered ', i12, ' Fake Pairs ')
c
c...Initialization
c
  100 nroot = LEN(root)
      nf = 0
      DO y=1,NYBIN
        DO x=1,NXBIN
          sx(x,y) = 0.0
          sxx(x,y) = 0.0
          sn(x,y) = 0.0
        ENDDO
      ENDDO
      DO i=1,5
        fakehist(i) = 0.0
      ENDDO
      histadd = 1.0/nfake
c
c...Loop Over All Possible FAKE Files
c
      DO count=1,nfake
        WRITE (lb,9001) root,count
        nlb = nroot + 6
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        recl=fakerecl(count),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        CALL postfast(flist(1,nf+1),fakerecl(count))
        CLOSE (1)
c
c...Fill Histogram And Mask Magnitude Field
c
        DO i=nf+1,nf+fakenum(count)
          j = flist(4,i)
          IF ((j.ge.1).and.(j.le.5)) THEN
            fakehist(j) = fakehist(j)+histadd
          ENDIF
          flist(5,i) = MOD(flist(5,i),10000)
        ENDDO
c
c...Compute Bins
c
        DO y=1,NYBIN
          DO x=1,NXBIN
            fake(x,y) = 0.0
          ENDDO
        ENDDO
        jf = 0
        DO i=nf+1,nf+fakenum(count)
          IF (postok(flist(4,i)).ne.0) THEN
            x = XFACTOR*flist(5,i) + (1-IXMIN)
            y = YFACTOR*flist(3,i) + (1-IYMIN)
            IF  ((x.ge.1).and.(x.le.NXBIN)
     *      .and.(y.ge.1).and.(y.le.NYBIN)) THEN
              fake(x,y) = fake(x,y) + 1.0
              jf = jf+1
            ENDIF
          ENDIF
        ENDDO
c
c...Sum
c
        DO y=1,NYBIN
          DO x=1,NXBIN
            z = fake(x,y)
            sx(x,y) = sx(x,y) + z
            sxx(x,y) = sxx(x,y) + z*z
            sn(x,y) = sn(x,y) + 1.0
          ENDDO
        ENDDO
        WRITE (*,9004) count,fakenum(count),jf
        nf = nf+fakenum(count)
      ENDDO
      DO y=1,NYBIN
        DO x=1,NXBIN
          IF (sn(x,y).le.0.0) THEN
            sxx(x,y) = 1.0
          ELSEIF (sn(x,y).le.1.0) THEN
            sxx(x,y) = 1.0
          ELSE
            sx(x,y) = sx(x,y)/sn(x,y)
            sxx(x,y) = SQRT(sxx(x,y)/sn(x,y) - sx(x,y)*sx(x,y))
          ENDIF
          sn(x,y) = SQRT(MAX(1.0,sx(x,y)))
        ENDDO
      ENDDO
c
c...Do The Same Thing For TRUTH
c
      DO y=1,NYBIN
        DO x=1,NXBIN
          truth(x,y) = 0.0
        ENDDO
      ENDDO
      DO i=1,nr
        IF (postok(rlist(4,i)).ne.0) THEN
          x = XFACTOR*rlist(5,i) + (1-IXMIN)
          y = YFACTOR*rlist(3,i) + (1-IYMIN)
          IF  ((x.ge.1).and.(x.le.NXBIN)
     *    .and.(y.ge.1).and.(y.le.NYBIN)) THEN
            truth(x,y) = truth(x,y) + 1.0
          ENDIF
        ENDIF
      ENDDO
c
c...Compute Normalization
c
      x = NXBIN
      y = NYBIN
      CALL postnorm(x,sx(1,y),sn(1,y),truth(1,y),z)
      DO y=1,NYBIN
        DO x=1,NXBIN
          sx(x,y) = z*sx(x,y)
          sxx(x,y) = z*sxx(x,y)
          sn(x,y) = z*sn(x,y)
        ENDDO
      ENDDO
      RETURN
      END
