      SUBROUTINE  definebox
c
c...Initialize The Summation Boxes
c
c	Poor storage allocation.  Maximum number of Boxes Is (NBOXMAX,NBOXMAX)
c
c	NOTE:  All parameters are (3)-(1) vs (1) to get almost flat relation.
c
c	WARNING:  xmin/xmax/ymin/ymax/wide know about NBOXMAX
c		  probmin/probwide know about PROBDIM
c
      INCLUDE
     *            'mujfoe.inc'
      INTEGER
     *            x, y, k
c
c...[1] Is Total Magnitude
c
  100 xmin(1) =   5.0
      xmax(1) =  25.0
      ymin(1) = -10.0
      ymax(1) =  10.0
      wide(1) =   0.5
      probmin(1) = xmin(1)
      probwid(1) = 0.1
c
c...[2] Is Lump
c
      xmin(2) =  0.0
      xmax(2) =  60.0
      ymin(2) = -30.0
      ymax(2) =  30.0
      wide(2) =   1.0
      probmin(2) = xmin(2)
      probwid(2) = 0.3
c
c...[3] Is Good
c
      xmin(3) =   0.0
      xmax(3) =  60.0
      ymin(3) =  -30.0
      ymax(3) =   30.0
      wide(3) =   1.0
      probmin(3) = xmin(3)
      probwid(3) = 0.3
c
c...[4] Is R0
c
      xmin(4) =   0.0
      xmax(4) =  32.0
      ymin(4) =  -16.0
      ymax(4) =   16.0
      wide(4) =   0.5
      probmin(4) = xmin(4)
      probwid(4) = 0.2
c
c...[5] Is Sigma
c
      xmin(5) =   0.0
      xmax(5) =  8.0
      ymin(5) =   -4.0
      ymax(5) =    4.0
      wide(5) =   0.125
      probmin(5) = xmin(5)
      probwid(5) = 0.05
c
c...6->10 Are The Same As 1->5
c
      DO k=1,5
        xmin(k+5) = xmin(k)
        xmax(k+5) = xmax(k)
        ymin(k+5) = ymin(k)
        ymax(k+5) = ymax(k)
        wide(k+5) = wide(k)
        probmin(k+5) = probmin(k)
        probwid(k+5) = probwid(k)
      ENDDO
c
c...All Done Defining Boxes.  Initialize All The Other Things
c
      nr = 10
      DO k=1,nr
        ixmax(k) = (xmax(k)-xmin(k))/wide(k) + 1.0
        ixmax(k) = MIN(ixmax(k),NBOXMAX)
        iymax(k) = (ymax(k)-ymin(k))/wide(k) + 1.0
        iymax(k) = MIN(iymax(k),NBOXMAX)
        zmin(k) = ymin(k) + 0.5*wide(k)
        zmax(k) = ymax(k) - 0.5*wide(k)
        izmax(k) = (zmax(k)-zmin(k))/wide(k) + 1.0
        ixmax(k) = MIN(izmax(k),NBOXMAX)
      ENDDO
      DO k=1,nr
        DO y=1,iymax(k)
          DO x=1,ixmax(k)
            iboxes(x,y,k) = 0
          ENDDO
        ENDDO
        DO y=1,izmax(k)
          DO x=1,ixmax(k)
            jboxes(x,y,k) = 0
          ENDDO
        ENDDO
        itotal(k) = 0
        jtotal(k) = 0
      ENDDO
      RETURN
      END
