      SUBROUTINE  postfxfy
c
c...Smooth FAKE Into F(x)*F(y)
c
      INCLUDE
     *            'postanal.inc'
      PARAMETER
     *            nqmax = NXBIN*NYBIN,
     *            factor = 0.5D00,
     *            toosmall = 0.0001D00
      DOUBLE PRECISION
     *            model(NXBIN), xfit(NQMAX), yfit(NQMAX),
     *            coef(NMMAX), guess(NMMAX+2),z, fx, gy, test
      INTEGER
     *            x, y, ising, nfit, ncoef, lowlim, highlim
c
 9001 FORMAT (' Too Few Points On Bright Slope ', i10)
 9002 FORMAT (' Too Few Points On Bright Slope ', i10)
 9003 FORMAT (' Too Few Points In Y ', i10)
 9004 FORMAT (' Improvement Failed ', i10)
c
c...Use Mean Of Outer Bins To Make First Guess Model
c
  100 DO x=1,NXBIN
        model(x) = 0.0D00
      ENDDO
      DO y=NYBIN-4,NYBIN
        DO x=1,NXBIN
          model(x) = model(x)+sx(x,y)
        ENDDO
      ENDDO
      DO x=1,NXBIN
        model(x) = model(x)/5.0D00
      ENDDO
      test = model(1)
      DO x=2,NXBIN
        test = MAX(test,model(x))
      ENDDO
      test = FACTOR*test
c
c...Extract Bright Slope
c
      nfit = 0
      DO x=1,NXBIN-1
        IF (model(x).gt.0.0D00) THEN
          nfit = nfit+1
          xfit(nfit) = x
          yfit(nfit) = LOG(model(x))
      write (*,9998) nfit,xfit(nfit),yfit(nfit)
 9998 format (' Bright', i3, 2f10.4)
          IF (model(x).gt.test) THEN
            lowlim = x
            GO TO 110
          ENDIF
        ENDIF
      ENDDO
  110 ncoef = 2
      IF (nfit.lt.ncoef) THEN
        WRITE (*,9001) nfit
        CALL EXIT
      ENDIF
      CALL postpoly(nfit,xfit,yfit, ncoef,coef)
      guess(1) = coef(1)
      guess(2) = coef(2)
c
c...Extract Faint Slope
c
      nfit = 0
      DO x=NXBIN,2,-1
        IF (model(x).gt.0.0D00) THEN
          nfit = nfit+1
          xfit(nfit) = x
          yfit(nfit) = LOG(model(x))
      write (*,9997) nfit,xfit(nfit),yfit(nfit)
 9997 format (' Faint', i3, 2f10.4)
          IF (model(x).gt.(FACTOR*model(x-1))) THEN
            highlim = x
            GO TO 120
          ENDIF
        ENDIF
      ENDDO
  120 ncoef = 2
      IF (nfit.lt.ncoef) THEN
        WRITE (*,9002) nfit
        CALL EXIT
      ENDIF
      CALL postpoly(nfit,xfit,yfit, ncoef,coef)
      guess(3) = coef(1)
      guess(4) = coef(2)
c
c...Extract Y Fit
c
      nfit = 0
      DO x=1,NXBIN
        IF (x.le.lowlim) THEN
          z = EXP(guess(1) + x*guess(2))
        ELSEIF (x.ge.highlim) THEN
          z = EXP(guess(3) + x*guess(4))
        ELSE
          z = -1.0D00
        ENDIF
        IF (z.gt.0.0D00) THEN
          DO y=5,NYBIN
            IF (sx(x,y).gt.0.0D00) THEN
              nfit = nfit+1
              xfit(nfit) = y
              yfit(nfit) = sx(x,y)/z
            ENDIF
          ENDDO
        ENDIF
      ENDDO
      ncoef = 3
      IF (nfit.lt.ncoef) THEN
        WRITE (*,9003) nfit
        CALL EXIT
      ENDIF
      CALL postpoly(nfit,xfit,yfit, ncoef,coef)
      guess(5) = coef(1)
      guess(6) = coef(2)
      guess(7) = coef(3)
c
c...Improve
c
      guess(8) = lowlim
      guess(9) = highlim
      write (*,9991) (guess(x),x=1,7)
 9991 format (7f10.4)
      CALL postiter(7,guess,x)
      IF (x.ne.0) THEN
        WRITE (*,9004) x
      ENDIF
      write (*,9991) (guess(x),x=1,7)
c
c...Fill The Model Array.
c
      lowlim = guess(8)+0.5D00
      highlim = guess(9)+0.5D00
      DO x=1,NXBIN
        IF (x.le.lowlim) THEN
          fx = EXP(guess(1)+guess(2)*x)
        ELSEIF (x.ge.highlim) THEN
          fx = EXP(guess(3)+guess(4)*x)
        ELSE
          fx = 0.0D00
        ENDIF
        DO y=1,NYBIN
          gy = guess(5) + y*(guess(6) + y*guess(7))
          mx(x,y) = MAX(fx*gy,TOOSMALL)
        ENDDO
      ENDDO
      DO y=1,NYBIN
        fx = MAX(0.5D00*(mx(lowlim,y)+mx(highlim,y)), TOOSMALL)
        DO x=lowlim+1,highlim-1
          mx(x,y) = fx
        ENDDO
      ENDDO
c
c...Fill In The Uncertainty.  Model Is SQRT(N)
c
      DO y=1,NYBIN
        DO x=1,NXBIN
          mn(x,y) = SQRT(mx(x,y))
        ENDDO
      ENDDO
      RETURN
      END
