      SUBROUTINE  postnorm(nn,zo,szo,zt,fact)
c
c...Compute The Scaling Between FAKE and TRUTH
c
      INCLUDE
     *            'postanal.inc'
      INTEGER
     *            nn, i, j, k, sing, norder
      REAL
     *            zo(*), szo(*), zt(*), fact
      DOUBLE PRECISION
     *            x, y, w, dv(10), zlhs(10), zrhs(10,10), r, yc,
     *            chisq, coef(10), scoef(10), sumw, sigma
c
 9001 FORMAT (' Singular Matrix In POSTNORM')
 9002 FORMAT (' Factor=', f6.4, ' +/- ', f6.4)
c
c...Initialization
c
  100 norder = 1
      DO i=1,norder
        zlhs(i) = 0.0D00
        coef(i) = 0.0D00
        DO j=1,norder
          zrhs(j,i) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      sumw = 0.0D00
c
c...Summation
c
      DO i=1,nn
        x = zo(i)
        w = 1.0D00/(szo(i)*szo(i))
        y = zt(i)
        dv(1) = x
        DO j=1,norder
          zlhs(j) = zlhs(j) + y*dv(j)*w
          DO k=1,norder
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)*w
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(norder,zrhs,sing)
      IF (sing.ne.0) THEN
        WRITE (*,9001)
        fact = 1.0
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,norder
        DO j=1,norder
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Chi Squared
c
      DO i=1,nn
        x = zo(i)
        w = 1.0D00/(szo(i)*szo(i))
        y = zt(i)
        dv(1) = x
        yc = 0.0D00
        DO j=1,norder
          yc = yc + dv(j)*coef(j)
        ENDDO
        r = y-yc
        chisq = chisq + w*r*r
        sumw = sumw + w
      ENDDO
      chisq = (chisq/(nn-(norder+1)))*(sumw/nn)
c
c...Errors
c
      sigma = SQRT(nn/sumw)
      DO i=1,norder
        scoef(i) = sigma*SQRT(zrhs(i,i))
      ENDDO
      fact = coef(1)
      WRITE (*,9002) fact,scoef(1)
      RETURN
      END
