      SUBROUTINE  slasetup(id1,emul1,id2,emul2,fatal)
c
c...Set Up SLALIB
c
      INCLUDE
     *            'goproc.inc'
      DOUBLE PRECISION
     *             djm, oaz, ozd, oha, field_epoch, obs_long,
     *             ara, adec, ora, odec, xi, eta, obs_lat, obs_elev,
     *             obs_temp, obs_pres, obs_humid, mid_exp, obs_wave,
     *             obs_tlr, obs_xpolar, obs_ypolar, obs_dut, r, d, ep
      INTEGER
     *             fatal, j, id1, id2, cyy, cdn
      CHARACTER*2
     *             emul1, emul2
c
c...Initialization
c
  100 field_epoch = 2000.0D00
      obs_long = -(116.0D00 + 51.8D00/60.0D00)/radian
      obs_lat = (33.0D00 + 21.4D00/60.0D00)/radian
      obs_elev = 1706.0D00
      obs_temp = 285.0D00
      obs_pres = 1013.25D00*EXP(-obs_elev/8149.9415D00)
      obs_humid = 0.25D00
      obs_tlr = 0.0065D00
      obs_xpolar = 0.0D00
      obs_ypolar = 0.0D00
      obs_dut = 0.0D00
      obs_scale = 67.18D00
      obs_unit = 3600.0D00*100000.0D00*radian/obs_scale
      obs_disco = -0.3333D00
c
c...Processing For (1)
c
      IF ((id1.le.0).or.(id1.gt.NFDIM)) THEN
        fatal = 11
        RETURN
      ENDIF
      CALL sla_CALDJ(yy1(id1),mm1(id1),dd1(id1), djm,j)
      IF (j.ne.0) THEN
        fatal = 12
        RETURN
      ENDIF
      CALL sla_MAPPA(field_epoch,djm,amprms1)
      mid_exp = djm + ut1(id1)/24.0D00
      IF ((emul1.eq.'SJ').or.(emul1.eq.'SF')) THEN
        obs_wave = 0.48D00
      ELSEIF (emul1.eq.'SF') THEN
        obs_wave = 0.65D00
      ELSEIF (emul1.eq.'SN') THEN
        obs_wave = 0.85D00
      ELSEIF (emul1.eq.'SO') THEN
        obs_wave = 0.41D00
      ELSEIF (emul1.eq.'SE') THEN
        obs_wave = 0.65D00
      ELSE
        fatal = 13
        RETURN
      ENDIF
      CALL sla_AOPPA(mid_exp, obs_dut, obs_long, obs_lat, obs_elev,
     *               obs_xpolar, obs_ypolar, obs_temp, obs_pres,
     *               obs_humid, obs_wave, obs_tlr, aoprms1)
      r = ra1(id1)
      d = dec1(id1)
      CALL sla_CALYD(yy1(id1),mm1(id1),dd1(id1), cyy,cdn,j)
      IF (MOD(cyy,4).eq.0) THEN
        ep = cyy + (cdn + ut1(id1)/24.0D00 - 1.0D00)/366.0D00
      ELSE
        ep = cyy + (cdn + ut1(id1)/24.0D00 - 1.0D00)/365.0D00
      ENDIF
      CALL sla_PRECES('FK5',ep,field_epoch,r,d)
      CALL sla_MAPQKZ(r,d,amprms1,ara,adec)
      CALL sla_AOPQK(ara,adec,aoprms1,oaz,ozd,oha,odec1,ora1)
c
c...Processing For (2)
c
      IF ((id2.le.0).or.(id2.gt.NFDIM)) THEN
        fatal = 14
        RETURN
      ENDIF
      CALL sla_CALDJ(yy2(id2),mm2(id2),dd2(id2), djm,j)
      IF (j.ne.0) THEN
        fatal = 15
        RETURN
      ENDIF
      CALL sla_MAPPA(field_epoch,djm,amprms2)
      mid_exp = djm + ut2(id2)/24.0D00
      IF ((emul2.eq.'SJ').or.(emul2.eq.'SF')) THEN
        obs_wave = 0.48D00
      ELSEIF (emul2.eq.'SF') THEN
        obs_wave = 0.65D00
      ELSEIF (emul2.eq.'SN') THEN
        obs_wave = 0.85D00
      ELSEIF (emul2.eq.'SO') THEN
        obs_wave = 0.41D00
      ELSEIF (emul2.eq.'SE') THEN
        obs_wave = 0.65D00
      ELSE
        fatal = 16
        RETURN
      ENDIF
      CALL sla_AOPPA(mid_exp, obs_dut, obs_long, obs_lat, obs_elev,
     *               obs_xpolar, obs_ypolar, obs_temp, obs_pres,
     *               obs_humid, obs_wave, obs_tlr, aoprms2)
      r = ra2(id2)
      d = dec2(id2)
      CALL sla_CALYD(yy2(id2),mm2(id2),dd2(id2), cyy,cdn,j)
      IF (MOD(cyy,4).eq.0) THEN
        ep = cyy + (cdn + ut2(id2)/24.0D00 - 1.0D00)/366.0D00
      ELSE
        ep = cyy + (cdn + ut2(id2)/24.0D00 - 1.0D00)/365.0D00
      ENDIF
      CALL sla_PRECES('FK5',ep,field_epoch,r,d)
      CALL sla_MAPQKZ(r,d,amprms2,ara,adec)
      CALL sla_AOPQK(ara,adec,aoprms2,oaz,ozd,oha,odec2,ora2)
c
      RETURN
      END
