      SUBROUTINE  itera
c
c...Iterate In A Small Region
c
      INCLUDE
     *            'magover.inc'
      PARAMETER
     *            nplotmax = 75
      CHARACTER*1
     *            c
      INTEGER
     *            i, err, plotn1, plotn2,
     *            plotx1(NEXTMAX), ploty1(NEXTMAX), plotm1(NEXTMAX),
     *            plotx2(NEXTMAX), ploty2(NEXTMAX), plotm2(NEXTMAX),
     *            ploti1(NEXTMAX), ploti2(NEXTMAX)
c
 9001 FORMAT (' N=', i7, '   SigmaX=', f6.2, '   SigmaY=', f6.2)
 9002 FORMAT (' X(', i2, ')=', 1pe14.7, '+/-', 1pe9.3,
     *      '   Y(', i2, ')=', 1pe14.7, '+/-', 1pe9.3)
 9003 FORMAT (' (R=Restart,P=Pairs,I=Iterate,C=Continue,X=Exit): ' $)
 9004 FORMAT (a)
 9005 FORMAT (' SubArea Processing Loop')
c
c...Preliminary Processing
c
  100 WRITE (*,9005)
      CALL extract1
      CALL extract2
      CALL dstguess(err)
      IF (err.eq.0) GO TO 110
c
c...Copy, Sort By Magnitude And Plot And/Or Enter Pairs
c
      DO i=1,n1p
        plotx1(i) = x1p(i)
        ploty1(i) = y1p(i)
        plotm1(i) = m1p(i)
        ploti1(i) = i
      ENDDO
      CALL iuqsrt(n1p,plotm1,ploti1)
      CALL ireord(n1p,ploti1,plotx1,tmp)
      CALL ireord(n1p,ploti1,ploty1,tmp)
      plotn1 = MIN(n1p,NPLOTMAX)
      DO i=1,n2p
        plotx2(i) = x2p(i)
        ploty2(i) = y2p(i)
        plotm2(i) = m2p(i)
        ploti2(i) = i
      ENDDO
      CALL iuqsrt(n2p,plotm2,ploti2)
      CALL ireord(n2p,ploti2,plotx2,tmp)
      CALL ireord(n2p,ploti2,ploty2,tmp)
      plotn2 = MIN(n2p,NPLOTMAX)
      CALL plotit(plotn1,plotx1,ploty1,plotm1,
     *            plotn2,plotx2,ploty2,plotm2)
      CALL guess(err,plotn1,ploti1,plotn2,ploti2)
      IF (err.ne.0) GO TO 100
  110 CALL smallxform
c
c...Display And Select Action
c
  120 WRITE (*,9001) npair,sigmax,sigmay
      DO i=1,ncoef
        WRITE (*,9002) i,xcoef(i),sxcoef(i),i,ycoef(i),sycoef(i)
      ENDDO
  130 WRITE (*,9003)
      READ  (*,9004,err=130,end=200) c
      IF ((c.ge.'a').and.(c.le.'z')) THEN
        c = CHAR(ICHAR(c)-32)
      ENDIF
      IF (c.eq.'R') THEN
        GO TO 100
      ELSEIF (c.eq.'P') THEN
        GO TO 100
      ELSEIF (c.eq.'C') THEN
        RETURN
      ELSEIF (c.eq.'X') THEN
        GO TO 200
      ELSE
        IF (c.ne.'I') GO TO 120
      ENDIF
c
c...Iterate
c
      CALL smallfind
      CALL smallfit(x1p, xcoef,sxcoef,sigmax,err)
      IF (err.ne.0) GO TO 120
      CALL smallfit(y1p, ycoef,sycoef,sigmay,err)
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      GO TO 120
c
  200 CALL EXIT
      END
