      PROGRAM  listverify
c
c...Demonstrate That .AYES Entries Appear In .ASC Files
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1*1000*1000,
     *         nsmax = 20
      INTEGER
     *         n, nc, xref(NMAX,2), yref(NMAX,2), xtest(NMAX),
     *         ytest(NMAX), ntest, nlb, i, j, nff(2), mref(NMAX,2),
     *         idx(NMAX), tmp(NMAX), mtest(NMAX), nstack, hit, miss,
     *         xstack(NSMAX), ystack(NSMAX), mstack(NSMAX), test, k,
     *         tstack(NSMAX)
      CHARACTER*64
     *         lb, ff(2)
c
 9001 FORMAT (' Enter Solution ROOT: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (i2, i10)
 9005 FORMAT (6i12)
 9006 FORMAT (3i12)
 9007 FORMAT (' Problem', 3i12)
 9008 FORMAT (' Test Of List ', i1, ' Was OK')
c
c...Open And Read The ASCII Version Of The Solution
c
  100 WRITE (*,9001)
      READ  (*,9002,err=100,end=200) nlb,lb
      IF (nlb.le.0) GO TO 200
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=100,
     *      form='formatted',
     *      name=lb(1:nlb)//'.ayes',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002) nff(1),ff(1)
      READ (1,9002) nff(2),ff(2)
      READ (1,9003) nc,n
      DO i=1,nc
        READ (1,9003)
      ENDDO
      DO i=1,n
        READ (1,9005) (xref(i,j),yref(i,j),mref(i,j),j=1,2)
      ENDDO
      CLOSE (1)
c
c...Loop Over Lists.  Start By Ingesting .ASC File
c
      DO j=1,2
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=ff(j)(1:nff(j)),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9006) ntest
        DO i=1,ntest
          READ (1,9006) xtest(i),ytest(i),mtest(i)
        ENDDO
        CLOSE (1)
c
c...Sort Both Lists
c
        DO i=1,n
          idx(i) = i
        ENDDO
        CALL iuqsrt(n,xref(1,j),idx)
        CALL ireord(n,idx,yref(1,j),tmp)
        CALL ireord(n,idx,mref(1,j),tmp)
        DO i=1,ntest
          idx(i) = i
        ENDDO
        CALL iuqsrt(ntest,xtest,idx)
        CALL ireord(ntest,idx,ytest,tmp)
        CALL ireord(ntest,idx,mtest,tmp)
c
c...Outer Loop Is Over REF List
c
        test = 0
        hit = 0
        miss = 0
        nstack = 0
        DO i=1,n
c
c...Inner Loop Is Over TEST List
c
  110     test = test+1
          IF (test.gt.ntest) THEN
            STOP 'No More TESTS'
          ENDIF
          nstack = nstack+1
          IF (nstack.gt.NSMAX) THEN
            nstack = nstack-NSMAX
          ENDIF
          xstack(nstack) = xtest(test)
          ystack(nstack) = ytest(test)
          mstack(nstack) = mtest(test)
          tstack(nstack) = test
          IF (xtest(test).lt.xref(i,j)) THEN
            GO TO 110
          ELSEIF (xtest(test).eq.xref(i,j)) THEN
            IF  ((ytest(test).eq.yref(i,j))
     *      .and.(mtest(test).eq.mref(i,j))) THEN
              hit = hit+1
              GO TO 120
            ENDIF
            GO TO 110
          ELSE
            DO k=1,NSMAX
              IF  ((xstack(k).eq.xref(i,j))
     *        .and.(ystack(k).eq.yref(i,j))
     *        .and.(mstack(k).eq.mref(i,j))) THEN
                hit = hit+1
                test = tstack(k)
                GO TO 120
              ENDIF
            ENDDO
            miss = miss+1
            GO TO 120
          ENDIF
  120     CONTINUE
        ENDDO
c
c...Make Sure Things Worked Out
c
        IF ((hit.ne.n).or.(miss.ne.0)) THEN
          WRITE (*,9007) j,hit,miss
        ELSE
          WRITE (*,9008) j
        ENDIF
      ENDDO
      GO TO 100
c
c...All Done
c
  200 CALL EXIT
      END
