      PROGRAM  xyverify
c
c...Demonstrate That Coefficients "Work"
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1*1000*1000,
     *         scale = 1.0D08,
     *         ncmax = 10
      INTEGER
     *         n, nc, x1(NMAX), x2(NMAX), y1(NMAX), y2(NMAX),
     *         m1(NMAX), m2(NMAX), nlb, i, j
      DOUBLE PRECISION
     *         xcoef(NCMAX), ycoef(NCMAX), sx, sxx, sy, syy, x, y,
     *         dv(NCMAX), xhat, yhat, dx, dy
      CHARACTER*64
     *         lb
c
 9001 FORMAT (' Enter Solution ROOT: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (i2, i10)
 9004 FORMAT (2x, 2(1x,1pe15.8))
 9005 FORMAT (6i12)
 9006 FORMAT (' N=', i10, '  <DX>=', f6.2, '+/-', f5.2,
     *        '   <DY>=', f6.2, '+/-', f5.2)
c
c...Open And Read The ASCII Version Of The Solution
c
  100 WRITE (*,9001)
      READ  (*,9002,err=100,end=200) nlb,lb
      IF (nlb.le.0) GO TO 200
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=100,
     *      form='formatted',
     *      name=lb(1:nlb)//'.ayes',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003)
      READ (1,9003)
      READ (1,9003) nc,n
      DO i=1,nc
        READ (1,9004) xcoef(i),ycoef(i)
      ENDDO
      DO i=1,n
        READ (1,9005) x1(i),y1(i),m1(i),x2(i),y2(i),m2(i)
      ENDDO
      CLOSE (1)
c
c...Check The Transformation
c
      sx = 0.0D00
      sxx = 0.0D00
      sy = 0.0D00
      syy = 0.0D00
      DO i=1,n
        x = x2(i)/SCALE
        y = y2(i)/SCALE
        dv( 1) = 1.0D00
        dv( 2) = x
        dv( 3) = y
        dv( 4) = x*x
        dv( 5) = x*y
        dv( 6) = y*y
        dv( 7) = x*x*x
        dv( 8) = x*x*y
        dv( 9) = x*y*y
        dv(10) = y*y*y
        xhat = 0.0D00
        yhat = 0.0D00
        DO j=1,nc
          xhat = xhat + dv(j)*xcoef(j)
          yhat = yhat + dv(j)*ycoef(j)
        ENDDO
        dx = 0.01D00*(x1(i) - xhat*SCALE)
        dy = 0.01D00*(y1(i) - yhat*SCALE)
        sx = sx + dx
        sxx = sxx + dx*dx
        sy = sy + dy
        syy = syy + dy*dy
      ENDDO
      sx = sx/n
      sxx = SQRT(sxx/n - sx*sx)
      sy = sy/n
      syy = SQRT(syy/n - sy*sy)
      WRITE (*,9006) n,sx,sxx,sy,syy
      GO TO 100
c
c...All Done
c
  200 CALL EXIT
      END
