      PROGRAM  fixpair
c
c...Process Pairs In FOCUS-Type Split Frames
c
      INCLUDE
     *            'pa6inc1.inc'
      CHARACTER*80
     *            lb
      INTEGER
     *            nlb, istar, jstar, iplate, n, npair, nbin
      DOUBLE PRECISION
     *            x1, y1, x2, y2, r, sr, srr, sn, sanity, scale,
     *            bincent, binwide, binlow, binhigh
      REAL
     *            bin(LS*LS/2), q1, q2, q3
      INTEGER
     *            dummy(LS*LS/2)
c
 9001 FORMAT (3i10, 2f10.4, i10)
 9002 FORMAT ('Enter Sanity,Scale,BinCent,BinWide (4f10.0): ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (4f10.0)
 9005 FORMAT (' NBin=', i4, '   Q1=', f10.3, '   Q2=', f10.3,
     *        '   Q3=', f10.3)
c
c...Open The Files
c
  100 CALL onlydskin(0)
      CALL dev_ttdoenv('A6FILES:PAIR.LIS',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      CALL dev_ttdoenv('A6FILES:PAIR.REJ',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=2
     *     )
c
c...Get Limit
c
      CALL passline(4,2,n,nlb,lb)
      IF (n.eq.4) GO TO 120
  110 WRITE (*,9002)
      READ  (*,9003,err=110,end=200) nlb,lb
  120 READ (lb(1:nlb),9004,err=110) sanity,scale,bincent,binwide
c
c...Outer Loops Over Unique Star Pairs
c
      npair = 0
      nbin = 0
      binlow = bincent - 0.5*binwide
      binhigh = bincent + 0.5*binwide
      DO istar=1,nstar-1
        IF (instar(istar).ne.0) THEN
          DO jstar=istar+1,nstar
            IF (instar(jstar).ne.0) THEN
c
c...Statistics From Transformed Positions
c
              sr = 0.0
              srr = 0.0
              sn = 0.0
              DO iplate=1,nplate
                x1 = xcalc(istar,iplate)
                y1 = ycalc(istar,iplate)
                x2 = xcalc(jstar,iplate)
                y2 = ycalc(jstar,iplate)
                IF  ((x1.ne.tag).and.(y1.ne.tag)
     *          .and.(x2.ne.tag).and.(y2.ne.tag)) THEN
                  r = SQRT((x2-x1)**2 + (y2-y1)**2)
                  sr = sr + r
                  srr = srr + r*r
                  sn = sn + 1.0
                ENDIF
              ENDDO
c
c...Save In Disk File
c
              n = sn
              IF (n.le.0) THEN
                sr = 0.0
                srr = 0.0
              ELSEIF (n.eq.1) THEN
                srr = 0.0
              ELSE
                sr = sr/sn
                srr = SQRT(srr/sn - sr*sr)
              ENDIF
              npair = npair+1
              sr = sr*scale
              srr = srr*scale
              IF (srr.le.sanity) THEN
                WRITE (1,9001) npair,looks(istar),looks(jstar),sr,srr,n
              ELSE
                WRITE (2,9001) npair,looks(istar),looks(jstar),sr,srr,n
              ENDIF
              IF ((sr.ge.binlow).and.(sr.le.binhigh)) THEN
                nbin = nbin+1
                bin(nbin) = srr
              ENDIF
c
c...End Of Loops
c
            ENDIF
          ENDDO
        ENDIF
      ENDDO
c
c...Median Filter
c
      IF (nbin.gt.3) THEN
        CALL qsrt(nbin,bin,dummy)
        q1 = bin(1*nbin/4 + 0.5)
        q2 = bin(2*nbin/4 + 0.5)
        q3 = bin(3*nbin/4 + 0.5)
        WRITE (*,9005) nbin,q1,q2,q3
      ENDIF
c
c...All Done
c
  200 CLOSE (1)
      CLOSE (2)
      CALL EXIT
      END
