      PROGRAM  fixxpair
c
c...Process Pairs In FOCUS-Type Split Frames
c
      INCLUDE
     *            'pa6inc1.inc'
      CHARACTER*80
     *            lb
      INTEGER
     *            nlb, istar, jstar, iplate, n, npair
      DOUBLE PRECISION
     *            x1, y1, x2, y2, r, sr, srr, sn, sanity, scale
c
 9001 FORMAT (3i10, 2f10.4, i10)
 9002 FORMAT (' Enter Sanity Limit: ' $)
 9003 FORMAT (f10.0)
 9004 FORMAT (' Enter Arcsec/Pixel: ' $)
c
c...Open The Files
c
  100 CALL onlydskin(0)
      CALL dev_ttdoenv('A6FILES:PAIR.X',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      CALL dev_ttdoenv('A6FILES:PAIR.REJ',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=2
     *     )
c
c...Get Limit
c
  110 WRITE (*,9002)
      READ  (*,9003,err=110,end=200) sanity
      IF (sanity.le.0.0) GO TO 110
  120 WRITE (*,9004)
      READ  (*,9003,err=120,end=200) scale
      IF (scale.eq.0.0) THEN
        scale = 1.0
      ENDIF
c
c...Outer Loops Over Unique Star Pairs
c
      npair = 0
      DO istar=1,nstar-1
        IF (instar(istar).ne.0) THEN
          DO jstar=istar+1,nstar
            IF (instar(jstar).ne.0) THEN
c
c...Statistics From Transformed Positions
c
              sr = 0.0
              srr = 0.0
              sn = 0.0
              DO iplate=1,nplate
                x1 = xcalc(istar,iplate)
                y1 = ycalc(istar,iplate)
                x2 = xcalc(jstar,iplate)
                y2 = ycalc(jstar,iplate)
                IF  ((x1.ne.tag).and.(y1.ne.tag)
     *          .and.(x2.ne.tag).and.(y2.ne.tag)) THEN
                  r = ABS(x2-x1)
                  sr = sr + r
                  srr = srr + r*r
                  sn = sn + 1.0
                ENDIF
              ENDDO
c
c...Save In Disk File
c
              n = sn
              IF (n.le.0) THEN
                sr = 0.0
                srr = 0.0
              ELSEIF (n.eq.1) THEN
                srr = 0.0
              ELSE
                sr = sr/sn
                srr = SQRT(srr/sn - sr*sr)
              ENDIF
              npair = npair+1
              sr = sr*scale
              srr = srr*scale
              IF (srr.le.sanity) THEN
                WRITE (1,9001) npair,looks(istar),looks(jstar),sr,srr,n
              ELSE
                WRITE (2,9001) npair,looks(istar),looks(jstar),sr,srr,n
              ENDIF
c
c...End Of Loops
c
            ENDIF
          ENDDO
        ENDIF
      ENDDO
c
c...All Done
c
  200 CLOSE (1)
      CLOSE (2)
      CALL EXIT
      END
