      SUBROUTINE getzd(iyy,idn,ihh,imm,iss, itel,alpha,delta, zdx,zdy)
c
c...Computes the zenith distance
c
c	ITEL = 1 for USNOFS
c	ITEL = 2 for KPNO
c
      IMPLICIT
     *           NONE
      REAL
     *           alpha, delta, zdx, zdy
      INTEGER
     *           iyy, idn, ihh, imm, iss, itel, iload
      REAL*8
     *           zlon, zlat, degrad, zjd, zjd0, gmst, omega, e, ut,
     *           gast, zalpha, zdelta, gha, zlha, sd, cd, sl, cl,
     *           sha, cha, sz, cz, ss, cs, tanzd, zlon1, zlon2,
     *           zlat1, zlat2, t, t0
      DATA
     *           zlon1/111.7400D00/, zlat1/35.1833D00/, iload/0/,
     *           zlon2/111.5993D00/, zlat2/32.9640D00/
c
 9101 FORMAT (' Undefined Observatory: ' i8)
c
c...One-Time Initialization
c
      IF (iload.eq.0) THEN
        iload=1
        degrad=ATAN(1.0D00)/45.0D00
      ENDIF
c
c...Sines And Cosines Of Various Things
c
      IF (itel.eq.1) THEN
        zlon = zlon1
        zlat = zlat1
      ELSEIF (itel.eq.2) THEN
        zlon = zlon2
        zlat = zlat2
      ELSE
        WRITE (*,9101) itel
        zdx = 0.0
        zdy = 0.0
        RETURN
      ENDIF
      zalpha = alpha
      zdelta = delta
      sd = SIN(zdelta*degrad)
      cd = COS(zdelta*degrad)
      sl = SIN(zlat*degrad)
      cl = COS(zlat*degrad)
      ut = DFLOAT(ihh)+DFLOAT(imm)/60.0D00+DFLOAT(iss)/3600.0D00
c
c...Compute GMST
c
      CALL compjd(iyy,idn,0,0,0, zjd0)
      t0 = (zjd0 - 2451545.0D00)/36525.00
      gmst = 6.69737456D00
     *     + 2400.051336D00*t0
     *     + 0.0000258622D00*t0*t0
     *     + 1.0027379093D00*ut
      CALL maketime(gmst)      
c
c...Compute OMEGA and E
c
      CALL compjd(iyy,idn,ihh,imm,iss, zjd)
      t = (zjd - 2451545.0D00)/36525.0D00
      omega = 125.04452D00
     *      - 1934.13626D00*t
     *      + 0.002071D00+t*t
      e = -0.00029D00*SIN(omega*degrad)
c
c...Finish Things
c
      gast = gmst + e
      CALL maketime(gast)
      gha = gast - zalpha
      CALL maketime(gha)
      zlha = 15.0D00*gha - zlon
      CALL makeangle(zlha)
      sha = SIN(zlha*degrad)
      cha = COS(zlha*degrad)
      cz = sl*sd + cl*cd*cha
      zdx = cl*sha/cz
      zdy = (sl/(cd*cz)) - sd/cd
      RETURN
      END
