      subroutine pcfit(xx,yy,aa,cc,zbar,pc,spc,stder,nfit,infit,nofit)
c
c...this fits the plate constants in one coordinate
c
      include 'pa6inc1.inc'
      parameter (l1=lc+1,l2=lc+2,l3=lc+3,l4=lc+4)
      dimension xx(*),yy(*),aa(*),cc(*),infit(*),zbar(*),pc(*),spc(*)
      dimension zrhs(lc,lc), zlhs(lc), dv(lc), coef(lc), scoef(lc)
      dimension ex(3), ey(3), ez(3), jnfit(lc), istat(ls)
      equivalence (zrhs(1,1),work3(1,1)),(zlhs(1),work3(1,l1)),
     * (dv(1),work3(1,l2)),(coef(1),work3(1,l3)),(scoef(1),work3(1,l4))
      equivalence (istat(1),work2(1,3))
c
 9601 FORMAT (' SINGULAR MATRIX IN PCFIT...IPUT=', I3)
 9602 FORMAT (1X, I3, 5(2X, F10.4))
c
      nofit=0
      do 110 i=1,nfit
      jnfit(i)=infit(i)
      pc(i)=tag
      spc(i)=tag
      zlhs(i)=0.0
      do 110 j=1,nfit
  110 zrhs(i,j)=0.0
c
      nin=0
      do 120 i=1,nstar
      istat(i)=0
      if (instar(i).eq.0) go to 120
      x=xx(i)
      y=yy(i)
      a=abar(i)
      c=acol(i)
      z=zbar(i)
      if ((x.eq.tag).or.(y.eq.tag).or.(a.eq.tag).or.(c.eq.tag).or.
     * (z.eq.tag)) go to 120
      nin=nin+1
      istat(i)=1
  120 continue
      ifit=0
      do 130 i=1,nfit
      if (jnfit(i).eq.1) ifit=ifit+1
  130 continue
c
c
c...if there are enough observations, the requested fit is done
c   if there are less than 3 observation, no fit is done
c   if there are 3 or 4 observations, the exact fit is done (to the first 3)
c   otherwise, the fit is done to the 3 linear plate constants
c
      if (nin.gt.(ifit+1)) go to 200
      if (nin.lt.3) go to 400
c ==>
c      if (nin.le.4) go to 160
c
      if (nin.eq.3) go to 160
c
      do 150 i=1,nfit
  150 jnfit(i)=0
      jnfit(1)=1
      jnfit(2)=1
      jnfit(3)=1
      go to 200
  160 j=0
      do 170 i=1,nstar
      if (istat(i).eq.0) go to 170
      if (j.ge.3) go to 170
      j=j+1
      ex(j)=xx(i)
      ey(j)=yy(i)
      ez(j)=zbar(i)
  170 continue
      x21=ex(2) - ex(1)
      x32=ex(3) - ex(2)
      y21=ey(2) - ey(1)
      y32=ey(3) - ey(2)
      z21=ez(2) - ez(1)
      z32=ez(3) - ez(2)
      pc(3)=(x32*z21 - x21*z32)/(x32*y21 - x21*y32)
      pc(2)=(y32*z21 - y21*z32)/(x21*y32 - x32*y21)
      pc(1)=ez(2) - pc(2)*ex(2) - pc(3)*ey(2)
      return
c
c
c...here to do the requested fit
c
  200 do 230 istar=1,nstar
      if (istat(istar).eq.0) go to 230
      x=xx(istar)
      y=yy(istar)
      a=aa(istar)
      c=cc(istar)
      w=1.0
      if (istar.eq.iparst) w=w*piampl
      z=zbar(istar)
      if ((x.eq.tag).or.(y.eq.tag).or.(a.eq.tag).or.(c.eq.tag)
     * .or.(z.eq.tag)) go to 230
      iput=0
      do 210 iget=1,nfit
      if (jnfit(iget).ne.1) go to 210
      iput=iput+1
      call termpc(iget,x,y,a,c,term)
      dv(iput)=term
  210 continue
      do 220 i=1,iput
      zlhs(i)=zlhs(i) + w*dv(i)*z
      do 220 j=1,iput
  220 zrhs(i,j)=zrhs(i,j) + w*dv(i)*dv(j)
  230 continue
      call matinv(zrhs,iput,lc,det)
      if (det.ne.0.0) go to 235
      write (*,9601,iostat=junk) iput
      do 232 i=1,nstar
  232 write (*,9602,iostat=junk) i,xx(i),yy(i),aa(i),cc(i),zbar(i)
      call doclose(0)
      stop 'fortran stop...singular matrix in pcfit'
  235 do 240 i=1,iput
      coef(i)=0.0
      do 240 j=1,iput
  240 coef(i)=coef(i) + zrhs(i,j)*zlhs(j)
      chisq=0.0
      do 250 istar=1,nstar
      if (istat(istar).eq.0) go to 250
      x=xx(istar)
      y=yy(istar)
      a=aa(istar)
      c=cc(istar)
      w=1.0
      if (istar.eq.iparst) w=w*piampl
      z=zbar(istar)
      if ((x.eq.tag).or.(y.eq.tag).or.(a.eq.tag).or.(c.eq.tag)
     * .or.(z.eq.tag)) go to 250
      iput=0
      do 245 iget=1,nfit
      if (jnfit(iget).ne.1) go to 245
      iput=iput+1
      call termpc(iget,x,y,a,c,term)
      dv(iput)=term
  245 continue
      zc=0.0
      do 247 i=1,iput
  247 zc=zc + coef(i)*dv(i)
      chisq=chisq + w*(z-zc)*(z-zc)
  250 continue
c
c ==>
c      free=nin - (iput+1)
c
      free=nin - iput
c
      stder=sqrt(chisq/free)
      do 260 i=1,iput
  260 scoef(i)=stder*sqrt(zrhs(i,i))
c
      iput=0
      do 310 iget=1,nfit
      if (jnfit(iget).ne.1) go to 310
      iput=iput+1
      pc(iget)=coef(iput)
      spc(iget)=scoef(iput)
  310 continue
      return
c
  400 nofit=1
c      do 420 istar=1,nstar
c      xx(istar)=tag
c  420 yy(istar)=tag
      return
      end
