      subroutine plresid
c
c...dump of residuals and histograms by plate
c
      include 'pa6inc1.inc'
      parameter  nhbin=7
      dimension  qhbinx(nhbin), zhbinx(nhbin), prcnt(nhbin),
     *           qhbiny(nhbin), zhbiny(nhbin), total(nhbin)
c
 9401 FORMAT ('1STATISTICS FOR INDIVIDUAL PLATES')
 9402 FORMAT ('0 PLATE ', I4, '   W=', F5.2,
     * '   (mean,sigma)   x:(', f6.3, ',', f6.3,
     *               ')   y:(', f6.3, ',', f6.3, ')' )
 9403 FORMAT ('    BINS:', 10(1X, F5.2))
 9404 FORMAT ('   COUNT:', 10(1X, F5.0))
 9405 FORMAT (' PERCENT:', 10(1X, F5.1))
 9406 FORMAT ('   TOTAL:', 10(1X, F5.1))
 9407 FORMAT (' HISTOGRAM OF X-RESIDUALS   N=', F5.0)
 9408 FORMAT (' HISTOGRAM OF Y-RESIDUALS   N=', F5.0)
c
c...loop on plate index.
c
  100 write (4,9401)
      do 460 iplate=1,nplate
      sw =0.0
      sx =0.0
      sy =0.0
      sxx=0.0
      syy=0.0
      if  ((wplate(iplate).eq.tag)
     * .or.(wplate(iplate).eq.0.0)) go to 460
c
c...loop on star index to get sigma-x and sigma-y for each plate
c
  200 do 210 istar=1,nstar
      if (instar(istar).eq.0) go to 210
      x=xresid(istar,iplate)
      y=yresid(istar,iplate)
      if ((x.eq.tag).or.(y.eq.tag)) go to 210
      sw =sw  + 1.0
      sx =sx  + x
      sy =sy  + y
      sxx=sxx + x*x
      syy=syy + y*y
  210 continue
      if (sw.le.0.0) go to 460
      sx =sx/sw
      sy =sy/sw
      sxx=sqrt(sxx/sw - sx*sx)
      syy=sqrt(syy/sw - sy*sy)
      write (4,9402,iostat=junk) lookp(iplate),wplate(iplate),
     *                           sx,sxx,sy,syy
c
c...with sigma-x and sigma-y known, assemble a histogram
c
  300 do 310 i=1,nhbin
      qhbinx(i)=0.0
      qhbiny(i)=0.0
      zhbinx(i)=i*sxx/2.0
  310 zhbiny(i)=i*syy/2.0
c
      do 350 istar=1,nstar
      if (instar(istar).eq.0) go to 350
      x=xresid(istar,iplate)
      y=yresid(istar,iplate)
      if ((x.eq.tag).or.(y.eq.tag)) go to 350
      x=abs(x)
      y=abs(y)
      do 320 i=1,nhbin-1
      if (x.gt.zhbinx(i)) go to 320
      qhbinx(i)=qhbinx(i) + 1.0
      go to 330
  320 continue
      qhbinx(nhbin)=qhbinx(nhbin) + 1.0
  330 do 340 i=1,nhbin-1
      if (y.gt.zhbiny(i)) go to 340
      qhbiny(i)=qhbiny(i) + 1.0
      go to 350
  340 continue
      qhbiny(nhbin)=qhbiny(nhbin) + 1.0
  350 continue
c
  400 x=0.0
      do 410 i=1,nhbin
  410 x=x + qhbinx(i)
      if (x.le.0.0) go to 430
      z=100.0/x
      prcnt(1)=qhbinx(1)*z
      total(1)=prcnt(1)
      do 420 i=2,nhbin
      prcnt(i)=qhbinx(i)*z
  420 total(i)=total(i-1) + prcnt(i)
      write (4,9407,iostat=junk) x
      write (4,9403,iostat=junk) (zhbinx(i),i=1,nhbin-1)
      write (4,9404,iostat=junk) (qhbinx(i),i=1,nhbin)
      write (4,9405,iostat=junk) (prcnt(i),i=1,nhbin)
      write (4,9406,iostat=junk) (total(i),i=1,nhbin)
  430 x=0.0
      do 440 i=1,nhbin
  440 x=x + qhbiny(i)
      if (x.le.0.0) go to 460
      z=100.0/x
      prcnt(1)=qhbiny(1)*z
      total(1)=prcnt(1)
      do 450 i=2,nhbin
      prcnt(i)=qhbiny(i)*z
  450 total(i)=total(i-1) + prcnt(i)
      write (4,9408) x
      write (4,9403,iostat=junk) (zhbiny(i),i=1,nhbin-1)
      write (4,9404,iostat=junk) (qhbiny(i),i=1,nhbin)
      write (4,9405,iostat=junk) (prcnt(i),i=1,nhbin)
      write (4,9406,iostat=junk) (total(i),i=1,nhbin)
  460 continue
c
      return
      end
