      SUBROUTINE  polyfit(nn,xx,yy,rr,nc,cc,ss,stder)
c
c...Polynomial Fitting Routine
c
      IMPLICIT
     *            NONE
      PARAMETER
     *            ncmax = 10
      INTEGER
     *            nn, nc, i, j, k
      DOUBLE PRECISION
     *            xx(*), yy(*), rr(*), cc(*), ss(*), stder,
     *            zlhs(NCMAX), zrhs(NCMAX,NCMAX), dv(NCMAX),
     *            x, y, yc, r, chisq, det
c
c...Initialization
c
  100 DO i=1,nc
        zlhs(i) = 0.0D00
        DO j=1,nc
          zrhs(j,i) = 0.0D00
        ENDDO
        cc(i) = 0.0D00
      ENDDO
      chisq = 0.0D00
c
c...Accumulation
c
      DO i=1,nn
        x = xx(i)
        y = yy(i)
        dv(1) = 1.0D00
        DO j=2,nc
          dv(j) = dv(j-1)*x
        ENDDO
        DO j=1,nc
          zlhs(j) = zlhs(j) + dv(j)*y
          DO k=1,nc
            zrhs(k,j) = zrhs(k,j) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(zrhs,nc,NCMAX,det)
      IF (det.eq.0.0D00) THEN
        stder = -1.0D00
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        DO j=1,nc
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals
c
      DO i=1,nn
        x = xx(i)
        y = yy(i)
        dv(1) = 1.0D00
        DO j=2,nc
          dv(j) = dv(j-1)*x
        ENDDO
        yc = 0.0D00
        DO j=1,nc
          yc = yc + cc(j)*dv(j)
        ENDDO
        r = y-yc
        rr(i) = r
        chisq = chisq + r*r
      ENDDO
c
c...Errors
c
      stder = SQRT(chisq/(nn-(nc+1)))
      DO i=1,nc
        ss(i) = stder*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
