      SUBROUTINE  precession(iyy,idn,ihh,imm,iss, alpha,delta, px,py)
c
c...Precession From 1950 To Stated Epoch
c
      IMPLICIT
     *            NONE
      REAL
     *            alpha, delta, px, py
      INTEGER
     *            iyy, idn, ihh, imm, iss, iload
      REAL*8
     *            zalpha, zdelta, deltat, m, n, tau, xa, xd, e,
     *            degrad, timrad, sa, ca, sd, cd
      DATA
     *            iload/0/
c
c...OneTime Initialization
c
      IF (iload.eq.0) THEN
        iload = 1
        degrad = ATAN(1.0D00)/45.0D00
        timrad = 15.0D00*degrad
      ENDIF
c
c...Copy And Get SIN/COS
c
      zalpha = alpha
      zdelta = delta
      CALL decimal_year(iyy,idn,ihh,imm,iss, e)
      tau = 0.01D00*e
      m   = 46.0851D00 + 0.0279D00*tau
      n   = 20.0468D00 - 0.0085D00*tau
      deltat = e - 50.0D00
c
c..Compute Corrections
c
      sa = SIN(zalpha*timrad)
      ca = COS(zalpha*timrad)
      sd = SIN(zdelta*degrad)
      cd = COS(zdelta*degrad)
      xa = (deltat*(m*cd + n*sa*sd))/(54000.0D00*cd)
      xd = (deltat*(n*ca))/3600.0D00
c
c...One More Iteration
c
      sa = SIN((zalpha + 0.5D00*xa)*timrad)
      ca = COS((zalpha + 0.5D00*xa)*timrad)
      sd = SIN((zdelta + 0.5D00*xd)*degrad)
      cd = COS((zdelta + 0.5D00*xd)*degrad)
      px = (deltat*(m*cd + n*sa*sd))/(54000.0D00*cd)
      py = (deltat*(n*ca))/3600.0D00
      RETURN
      END
