      subroutine pstats(sigx,sigy,xcut,ycut)
c
c...this routine does a simple histogram of the residuals
c
      include 'pa6inc1.inc'
      parameter (nbin=7)
      dimension ix(nbin), iy(nbin), pp(nbin), qq(nbin)
c
 9201 FORMAT (1H0, I6, 25H POINTS IN X   BIN WIDTH=, F6.4,
     * 12h   of sigma=, f10.6)
 9202 FORMAT (17H   NUMBER PER BIN, 16(4X, I5))
 9203 FORMAT (17H  PERCENT PER BIN, 16(5X, F4.1))
 9204 FORMAT (1H0, I6, 25H POINTS IN Y   BIN WIDTH=, F6.4,
     * 12h   of sigma=, f10.6)
 9205 FORMAT (19H SUGGESTED CUT   X=, F10.6, 5H   Y=, F10.6)
 9206 FORMAT (17H INTEGRAL PERCENT, 16(4X, F5.1))
c
      z1=nbin-1
      scale=3.0/z1
      nx=0
      ny=0
      do 110 i=1,nbin
      ix(i)=0
  110 iy(i)=0
c
      do 140 istar=1,nstar
      if (instar(istar).eq.0) go to 140
      do 130 iplate=1,nplate
      xr=xresid(istar,iplate)
      yr=yresid(istar,iplate)
      if (xr.eq.tag) go to 120
      i=abs(xr/sigx)/scale + 1.0
      if (i.gt.nbin) i=nbin
      ix(i)=ix(i) + 1
      nx=nx+1
  120 if (yr.eq.tag) go to 130
      i=abs(yr/sigy)/scale + 1.0
      if (i.gt.nbin) i=nbin
      iy(i)=iy(i) + 1
      ny=ny+1
  130 continue
  140 continue
c
      write (2,9201,iostat=junk) nx,scale,sigx
      write (2,9202,iostat=junk) (ix(i),i=1,nbin)
      do 150 i=1,nbin
      z1=ix(i)
      z2=nx
      pp(i)=100.0*z1/z2
      if (i.eq.1) qq(i)=pp(i)
      if (i.ne.1) qq(i)=pp(i) + qq(i-1)
  150 continue
      write (2,9203,iostat=junk) (pp(i),i=1,nbin)
      write (2,9206,iostat=junk) (qq(i),i=1,nbin)
      write (2,9204,iostat=junk) ny,scale,sigy
      write (2,9202,iostat=junk) (iy(i),i=1,nbin)
      do 160 i=1,nbin
      z1=iy(i)
      z2=ny
      pp(i)=100.0*z1/z2
      if (i.eq.1) qq(i)=pp(i)
      if (i.ne.1) qq(i)=pp(i) + qq(i-1)
  160 continue
      write (2,9203,iostat=junk) (pp(i),i=1,nbin)
      write (2,9206,iostat=junk) (qq(i),i=1,nbin)
c
      do 210 i=1,nbin
      if (ix(i).gt.0) go to 210
      jx=i
      go to 220
  210 continue
      jx=nbin
  220 do 230 i=1,nbin
      if (iy(i).gt.0) go to 230
      jy=i
      go to 240
  230 continue
      jy=nbin
  240 if (jx.ge.nbin) jx=1
      if (jy.ge.nbin) jy=1
      do 250 i=jx,nbin
      if (ix(i).ne.0) go to 260
  250 continue
      jx=1
  260 do 270 i=jy,nbin
      if (iy(i).ne.0) go to 280
  270 continue
      jy=1
  280 xcut=jx-1
      xcut=xcut*sigx*scale
      ycut=jy-1
      ycut=ycut*sigy*scale
      write (2,9205,iostat=junk) xcut,ycut
      return
      end
