      PROGRAM  finalcheck
c
c...Verify All Zones In Order Of RA And Count Various Things
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 16*1024*1024,
     *         nmag = 25
      REAL
     *         x
      INTEGER
     *         nlb, n, nin, nout, nbright, nfaint, maghist(NMAG), m,
     *         zone, i, j, k, buf(3,NMAX), vec(3*NMAX), nr, ntotal,
     *         nraerror
      EQUIVALENCE
     *         (buf(1,1),vec(1))
      CHARACTER*64
     *         lb
      CHARACTER*4
     *         cz
c
 9001 FORMAT (i4.4)
 9002 FORMAT (f5.2, 2i12)
 9003 FORMAT (' N(Total)=', i12, '  N(In)=', i12, '  N(Out)=', i12)
 9004 FORMAT (' N(Bright)=', i12, '  N(Faint)=', i12)
 9005 FORMAT (' Mag=', f4.1, '  N=', i12)
 9006 FORMAT (' Zone ', i4, '  Is Too Big!', 2i12)
 9007 FORMAT (' Working On Zone ', i4)
 9008 FORMAT (' Zone ', i4, '  RA Errors=', i12)
c
c...Outer Loop Over Zones
c
  100 nin = 0
      nout = 0
      ntotal = 0
      nbright = 0
      nfaint = 0
      DO i=1,NMAG
        maghist(i) = 0
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='finalcheck.out',
     *      status='unknown',
     *      unit=2
     *     )
      DO zone=825,1800,75
        WRITE (*,9007) zone
c
c...Read ACC To Get Star Count
c
        WRITE (cz,9001) zone
        CALL f_doenv('MERGES:uj'//cz//'.acc',nlb,lb)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=199,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        n = 0
        DO i=1,96
          READ (1,9002) x,j,k
          n = n+k
        ENDDO
        CLOSE (1)
        IF (n.le.0) THEN
          GO TO 199
        ELSEIF (n.gt.NMAX) THEN
          WRITE (*,9006) zone,n,NMAX
          GO TO 199
        ENDIF
c
c...Read Entire CAT File
c
        lb(nlb-2:nlb) = 'cat'
        nr = 3*n
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        recl=nr,
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,rec=1) (vec(i),i=1,nr)
        CLOSE (1)
c
c...Count Various Things
c
        nraerror = 0
        DO i=1,n
          IF (i.lt.n) THEN
            IF (buf(1,i).gt.buf(1,i+1)) THEN
              nraerror = nraerror+1
            ENDIF
          ENDIF
          m = buf(3,i)
          IF (m.lt.0) THEN
            nout = nout+1
          ELSE
            nin = nin+1
          ENDIF
          ntotal = ntotal+1
          m = MOD(ABS(m),10000)/100
          IF (m.lt.1) THEN
            nbright = nbright+1
          ELSEIF (m.gt.NMAG) THEN
      write (*,9991) zone,i,m,buf(1,i),buf(2,i),buf(3,i)
      pause
 9991 format (6i12)
            nfaint = nfaint+1
          ELSE
            maghist(m) = maghist(m)+1
          ENDIF
        ENDDO
c
c...Report Damage
c
        IF (nraerror.gt.0) THEN
          WRITE (*,9008) zone,nraerror
          WRITE (2,9008) zone,nraerror
        ENDIF
c
c...All Done
c
  199   CONTINUE
      ENDDO
      WRITE (*,9003) ntotal,nin,nout
      WRITE (2,9003) ntotal,nin,nout
      WRITE (*,9004) nbright,nfaint
      WRITE (2,9004) nbright,nfaint
      DO i=1,NMAG
        x = i
        WRITE (*,9005) x,maghist(i)
        WRITE (2,9005) x,maghist(i)
      ENDDO
      CLOSE (2)
      CALL EXIT
      END
