      PROGRAM  testcd
c
c...See If Zone Looks OK
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nera = 96,
     *         nmax = 4*1024*1024,
     *         rfactor = (15.0D00*3600.0D00*100.0D00),
     *         dfactor = (        3600.0D00*100.0D00)
      DOUBLE PRECISION
     *         era(NERA), r, d, m
      INTEGER
     *         i, nlb, estart(NERA), elength(NERA), zone, inbuf(3),
     *         n, nrec, high, med, low, q, qual, field, outbuf(3)
      CHARACTER*80
     *         lb
      CHARACTER*4
     *         cz
      BYTE
     *         inbb(12), outbb(12)
      EQUIVALENCE
     *         (inbb(1),inbuf(1)), (outbb(1),outbuf(1))
c
 9001 FORMAT (i4.4)
 9002 FORMAT (f5.2, 2i12)
 9003 FORMAT ('I=', i2, ' Z=', f5.2, ' R=', f10.7, ' D=',
     *        f10.6, ' M=', f5.2, ' F=', i3, ' Q=', i1)
 9004 FORMAT (' Processing Zone ', i4)
 9005 FORMAT (' No Stars')
 9006 FORMAT (' Cannot Open ', a)
 9007 FORMAT (' No Space For Zone=', i3, 2i12)
c
c...Get Zone And Read ACC
c
  100 DO zone=825,1800,75
        WRITE (*,9004) zone
        WRITE (cz,9001) zone
        CALL f_doenv('MERGES:zone'//cz//'.acc',nlb,lb)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=190,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        n = 0
        DO i=1,NERA
          READ (1,9002) era(i),estart(i),elength(i)
          n = n+elength(i)
        ENDDO
        CLOSE (1)
c
c...Open The CAT File
c
        IF (n.le.0) THEN
          WRITE (*,9005)
        ELSEIF (n.gt.NMAX) THEN
          WRITE (*,9007) zone,n,NMAX
        ELSE
          nrec = 3*n
          lb(nlb-2:nlb) = 'cat'
          OPEN (
     *          access='direct',
     *          carriagecontrol='none',
     *          convert='big_endian',
     *          dispose='keep',
     *          form='unformatted',
     *          name=lb(1:nlb),
     *          readonly,
     *          recl=3,
     *          recordtype='fixed',
     *          shared,
     *          status='old',
     *          unit=1
     *         )
c
c...Print The Fiducials
c
c         DO i=1,NERA,16
c           IF (elength(i).gt.0) THEN
c             READ (1,rec=estart(i)) inbuf
      do i=81,91
      if (i.gt.0) then
      read (1,rec=i) inbuf
      write (*,9991) i,inbuf(1),inbuf(2),inbuf(3)
      pause
 9991 format (i12, 3z12)
              r = inbuf(1)/RFACTOR
              d = inbuf(2)/DFACTOR - 90.0D00
              q = ABS(inbuf(3))
              high = q/10000000
              q = q-high*10000000
              med = q/10000
              low = q-med*10000
              m = 0.01D00*low
              field = med
              qual = high
              WRITE (*,9003) i,era(i),r,d,m,field,qual
            ENDIF
          ENDDO
          CLOSE (1)
        ENDIF
c
c...All Done
c
        GO TO 199
  190   WRITE (*,9006) lb(1:nlb)
  199   CONTINUE
      ENDDO
      CALL EXIT
      END
