      SUBROUTINE  fit6(ncoef)
c
c...Like FIT3 Except Fitting To A Polynomial
c
      INCLUDE
     *            'piece12.inc'
      PARAMETER
     *            wide = 200,
     *            tall = 40,
     *            wstep = 100,
     *            tstep = 20
      INTEGER
     *            i, w1, w2, w, ff, ll, total, ymin, ymax, t1, t2,
     *            t, test, n, ier, lots, nmx, ncoef
      DOUBLE PRECISION
     *            yvar, sx, sy, sxmax, symax
c
 9001 FORMAT (' FIT3 CUBGCV IER=', i10)
c
c...Sort Pairs On X
c
  100 nspl = 0
      np = npp
      DO i=1,npp
        kdx(i) = i
        px(i) = ppx(i)
        py(i) = ppy(i)
        pq(i) = ppq(i)
        pr(i) = ppr(i)
        ps(i) = pps(i)
      ENDDO
      CALL iuqsrt(np,px,kdx)
      CALL ireord(np,kdx,py,tmp)
      CALL ireord(np,kdx,pr,tmp)
      CALL ireord(np,kdx,pq,tmp)
      CALL ireord(np,kdx,ps,tmp)
      lots = 10
c
c...Loop Over Width
c
      w1 = (px(1)/WSTEP)*WSTEP
      w2 = (((px(np)-1)/WSTEP)+1)*WSTEP - WSTEP
      DO w=w1,w2,wstep
c
c...Find Limits, Extremes, And Total
c
        DO ff=1,np
          IF (px(ff).ge.(w     )) GO TO 110
        ENDDO
  110   DO ll=np,ff,-1
          IF (px(ll).le.(w+WIDE)) GO TO 120
        ENDDO
  120   total = (ll+1-ff)
        ymin = py(ff)
        ymax = py(ff)
        DO i=ff+1,ll
          ymin = MIN(ymin,py(i))
          ymax = MAX(ymax,py(i))
        ENDDO
        t1 = (ymax/TSTEP)*TSTEP
        IF (ymin.lt.0) THEN
          t2 = (((ymin+1)/TSTEP)-1)*TSTEP + TALL
        ELSE
          t2 = (((ymin-1)/TSTEP)+1)*TSTEP + TALL
        ENDIF
c
c...Count Stars In Box And Exit If More Than TEST
c
        test = total/3
        DO t=t1,t2,-TSTEP
          n = 0
          sx = 0.0D00
          sy = 0.0D00
          DO i=ff,ll
            IF ((py(i).le.t).and.(py(i).ge.(t-TALL))) THEN
              n = n+1
              sx = sx + px(i)
              sy = sy + py(i)
            ENDIF
          ENDDO
          IF (n.gt.0) THEN
            sx = sx/n
            sy = sy/n
          ENDIF
          IF (t.eq.t1) THEN
            nmx = n
            sxmax = sx
            symax = sy
          ELSE
            IF (n.gt.nmx) THEN
              nmx = n
              sxmax = sx
              symax = sy
            ENDIF
          ENDIF
          IF (n.ge.test) THEN
            nspl = nspl+1
            splx(nspl) = sx
            sply(nspl) = sy
            yw(nspl) = 1.0D00
            kdx(nspl) = nspl
            GO TO 130
          ENDIF
        ENDDO
c
c...Patch To Choose Local Maximum If There Were Lots Of Stars In This Bin
c
        IF (nmx.gt.lots) THEN
          nspl = nspl+1
          splx(nspl) = sxmax
          sply(nspl) = symax
          yw(nspl) = 1.0D00
          kdx(nspl) = nspl
        ENDIF
  130   CONTINUE
      ENDDO
c
c...Fit With Trimming Polynomial
c
      CALL sanity(ncoef)
      w1 = splx(1)
      w2 = splx(nspl)+0.5D00
      DO w=1,w1-1
        fitdm(w) = MAGTAG
      ENDDO
      DO w=w1,w2
        sx = w
        dv(1) = 1.0D00
        DO i=2,ncoef
          dv(i) = dv(i-1)*sx
        ENDDO
        sy = 0.0D00
        DO i=1,ncoef
          sy = sy + coef(i)*dv(i)
        ENDDO
        fitdm(w) = sy+0.5D00
        IF (w.eq.w1) THEN
          rangemin = fitdm(w)
          rangemax = fitdm(w)
        ELSE
          rangemin = MIN(rangemin,fitdm(w))
          rangemax = MAX(rangemax,fitdm(w))
        ENDIF
      ENDDO
      DO w=w2+1,FAINTMAG
        fitdm(w) = MAGTAG
      ENDDO
      RETURN
      END
