      SUBROUTINE  outfit(nn,xx,yy,ww,ncoef)
c
c...Least Squares Fit
c
      INCLUDE
     *            'outanal.inc'
      DOUBLE PRECISION
     *            x, y, w, yc, yr, xx(*), yy(*), ww(*), sw
      INTEGER
     *            ising, i, j, k, ncoef, nn
c
c...Initialization
c
  100 DO i=1,ncoef
        coef(i) = 0.0D00
        scoef(i) = 0.0D00
        zlhs(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      stderr = 0.0D00
      sw = 0.0D00
c
c...Accumulation
c
      DO i=1,nn
        x = xx(i)
        y = yy(i)
        w = ww(i)
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*y*w
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)*w
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL outinvert(ncoef,ising)
      IF (ising.ne.0) THEN
        stderr = -1.0D00
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And Chi Squared
c
      DO i=1,nn
        x = xx(i)
        y = yy(i)
        w = ww(i)
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        yc = 0.0D00
        DO j=1,ncoef
          yc = yc + dv(j)*coef(j)
        ENDDO
        yr = y-yc
        chisq = chisq + w*yr*yr
        sw = sw+w
      ENDDO
c
c...Errors
c
      stderr = SQRT(chisq/(sw-(ncoef+1)))
      DO i=1,ncoef
        scoef(i) = stderr*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
