      SUBROUTINE  yapread
c
c...Read XDELTA.MAG And Prepare For Application
c
      INCLUDE
     *            'xmagapply.inc'
      PARAMETER
     *            fract = 0.7
      INTEGER
     *            nlb, field, i, j, mbar(NBMAX), msig(NBMAX)
      REAL
     *            mmin(NBMAX), mmax(NBMAX)
      CHARACTER*64
     *            lb
c
 9001 FORMAT (i5, 8f10.0)
 9002 FORMAT (i5, 18i5)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (q, a)
 9005 FORMAT (i4)
c
c...Load XDELTA.MAG
c
  100 CALL f_doenv('DGMPHA:xdelta.mag',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) nbin,(mmin(i),i=1,nbin)
      READ (1,9001) j,(mmax(i),i=1,nbin)
      DO i=1,nbin
        binmag(i) = 100.0D00*(mmin(i) + FRACT*(mmax(i)-mmin(i)))
      ENDDO
      DO i=1,NFMAX
        dofield(i) = 0
      ENDDO
      CALL f_doenv('xmagapply.fit',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=8
     *     )
  110 READ (1,9002,end=120) field,(mbar(i),msig(i),i=1,nbin)
      CALL xapfill(field,mbar,msig)
      GO TO 110
  120 CLOSE (1)
      CLOSE (8)
c
c...Get List Of Files To Process
c
      CALL system('\ls $DGMPHA/uj*.phd >apply.lis')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='delete',
     *      form='formatted',
     *      name='apply.lis',
     *      status='old',
     *      unit=1
     *     )
      nfile = 0
  130 READ (1,9004,end=140) nlb,lb
      i = INDEX(lb(1:nlb),'.phd')
      IF (i.le.0) GO TO 130
      nfile = nfile+1
      READ (lb(i-4:i-1),9005) fid(nfile)
      GO TO 130
  140 CLOSE (1)
      RETURN
c
c...Any Error Is Fatal
c
  200 WRITE (*,9003) lb(1:nlb)
      CALL EXIT
      END
