      SUBROUTINE  genprob(r)
c
c...Convert Splines Into Probability Table
c
      INCLUDE
     *            'mujfoe.inc'
      INTEGER
     *            r, ix, iy, ispl
      REAL
     *            x, y, a, b, h, l
      DOUBLE PRECISION
     *            t
c
c...Outer Loop Over Probability X Limits
c
  100 ispl = 1
      DO ix=1,PROBDIM
        x = (ix-1)*probwid(r) + probmin(r)
        IF ((x.lt.splx(1)).or.(x.gt.splx(nspl))) THEN
          DO iy=1,PROBDIM
            prob(ix,iy,r) = 0
          ENDDO
        ELSE
c
c...X Is In Range.  Compute Spline Values For The Ys
c
  110     IF (x.gt.splx(ispl+1)) THEN
            ispl = ispl+1
            GO TO 110
          ENDIF
          t = x-splx(ispl)
          l = lc(ispl)
     *      + t*(lcoef(ispl,1) + t*(lcoef(ispl,2) + t*lcoef(ispl,3)))
          a = ac(ispl)
     *      + t*(acoef(ispl,1) + t*(acoef(ispl,2) + t*acoef(ispl,3)))
          b = bc(ispl)
     *      + t*(bcoef(ispl,1) + t*(bcoef(ispl,2) + t*bcoef(ispl,3)))
          h = hc(ispl)
     *      + t*(hcoef(ispl,1) + t*(hcoef(ispl,2) + t*hcoef(ispl,3)))
c
c...Ridges Done In (Y-X) vs. X.  Restore true Y value.
c
          l = l+x
          a = a+x
          b = b+x
          h = h+x
c
c...Use These Values To Fill Probability Table
c
          DO iy=1,PROBDIM
            y = (iy-1)*probwid(r) + probmin(r)
            IF (y.lt.l) THEN
              prob(ix,iy,r) = 1
            ELSEIF (y.lt.a) THEN
              prob(ix,iy,r) = 2
            ELSEIF (y.le.b) THEN
              prob(ix,iy,r) = 3
            ELSEIF (y.le.h) THEN
              prob(ix,iy,r) = 2
            ELSE
              prob(ix,iy,r) = 1
            ENDIF
          ENDDO
        ENDIF
      ENDDO
      RETURN
      END
