      PROGRAM  zplot
c
c...Parse And Plot PMM Commands
c
c	X0 for PMM0 Is 132.0
c	X0 for PMM1 Is 388.0
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nx = 30,
     *         ny = 41,
     *         x0 = 388.0,
     *         dx = 16.0,
     *         y0 = 139.0,
     *         dy = 12.0
      INTEGER
     *         x, y, i, nzlevel, ntlevel, ix, iy
      REAL
     *         xx, yy, zz, tt, zmin, zmax, tmin, tmax, xmin, xmax,
     *         ymin, ymax, zlevel(50), tlevel(50), dz, dt,
     *         zbuf(NX,NY), tbuf(NX,NY)
c
 9001 FORMAT (10x,4f20.0)
 9002 FORMAT (' Index Error', 2i5, 2f10.3)
 9003 FORMAT (' Hole At (', i2, ',', i2, '): ' $)
 9004 FORMAT (2i5)
c
c...Initialize And Read
c
  100 DO y=1,NY
        DO x=1,NX
          zbuf(x,y) = 0.0
          tbuf(x,y) = 0.0
        ENDDO
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='z.sg1',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) xx,yy,zz,tt
      x = (xx-X0)/DX + 1.5
      IF ((x.le.0).or.(x.gt.NX)) THEN
        WRITE (*,9002) NX,x,xx,X0
        CALL EXIT
      ENDIF
      y = (yy-Y0)/DY + 1.5
      IF ((y.le.0).or.(y.gt.NY)) THEN
        WRITE (*,9002) NY,y,yy,Y0
        CALL EXIT
      ENDIF
      zbuf(x,y) = zz
      tbuf(x,y) = tt
      GO TO 110
  120 CLOSE (1)
c
c...Fill Holes
c
      DO y=1,NY
        DO x=1,NX
          IF (zbuf(x,y).le.0.0) THEN
  130       WRITE (*,9003) x,y
            READ  (*,9004,err=130) ix,iy
            zbuf(x,y) = zbuf(ix,iy)
          ENDIF
          IF (tbuf(x,y).le.0.0) THEN
  140       WRITE (*,9003) x,y
            READ  (*,9004,err=140) ix,iy
            tbuf(x,y) = tbuf(ix,iy)
          ENDIF
        ENDDO
      ENDDO
c
c...Min/Max
c
      zmin = zbuf(1,1)
      zmax = zmin
      tmin = tbuf(1,1)
      tmax = tmin
      DO y=1,NY
        DO x=1,NX
          zmin = MIN(zmin,zbuf(x,y))
          zmax = MAX(zmax,zbuf(x,y))
          tmin = MIN(tmin,tbuf(x,y))
          tmax = MAX(tmax,tbuf(x,y))
        ENDDO
      ENDDO
      dz = 0.1
      x = zmin*10.0
      y = zmax*10.0
      nzlevel = (y-x)+2
      DO i=1,nzlevel
        zlevel(i) = 0.1*x + (i-1)*dz
      ENDDO
      dt = 0.1
      x = tmin*10.0
      y = tmax*10.0
      ntlevel = (y-x)+2
      DO i=1,ntlevel
        tlevel(i) = 0.1*x + (i-1)*dt
      ENDDO
c
c...Plot ZBUF
c
      CALL mgoinit
      CALL mgosetup(-7)
      CALL mgoerase
      xmin = 1
      xmax = NX
      ymin = 1
      ymax = NY
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgoxlabel(4,'ZBUF')
      CALL mgocontour(zbuf,NX,NY,zlevel,nzlevel)
      CALL mgoprntplot(x)
c
c...Plot TBUF
c
      CALL mgoerase
      CALL mgosetlim(xmin,xmax,ymin,ymax)
      CALL mgobox(1,1)
      CALL mgoxlabel(4,'TBUF')
      CALL mgocontour(tbuf,NX,NY,tlevel,ntlevel)
      CALL mgoprntplot(y)
      CALL EXIT
      END
