      SUBROUTINE  zstats
c
c...Compute Various Statistics About FRZ0
c
      INCLUDE
     *            'surface.inc'
      INTEGER
     *            x, y
      REAL
     *            z
c
c...Copy Array And Get MIN/MAX
c
  100 ixmin = 1
      ixmax = 1
      iymin = 1
      iymax = 1
      bmin = frz0(ixmin,iymin)
      bmax = frz0(iymin,iymax)
      DO y=1,NY
        DO x=1,NX
          buf(x,y) = frz0(x,y)
          IF (buf(x,y).lt.bmin) THEN
            ixmin = x
            iymin = y
            bmin = buf(ixmin,iymin)
          ELSEIF (buf(x,y).gt.bmax) THEN
            ixmax = x
            iymax = y
            bmax = buf(ixmax,iymax)
          ENDIF
        ENDDO
      ENDDO
      xmin = 1
      xmax = NX
      ymin = 1
      ymax = NY
c
c...Look For Steepest Gradient In X
c
      xofgx = 1
      yofgx = 1
      gx = ABS(buf(xofgx+1,yofgx)-buf(xofgx,yofgx))
      DO y=1,NY
        DO x=1,NX-1
          z = ABS(buf(x+1,y)-buf(x,y))
          IF (z.gt.gx) THEN
            xofgx = x
            yofgx = y
            gx = z
          ENDIF
        ENDDO
      ENDDO
c
c...Look For Steepest Gradient In Y
c
      xofgy = 1
      yofgy = 1
      gy = ABS(buf(xofgy,yofgy+1)-buf(xofgy,yofgy))
      DO x=1,NX
        DO y=1,NY-1
          z = ABS(buf(x,y+1)-buf(x,y))
          IF (z.gt.gy) THEN
            xofgy = x
            yofgy = y
            gy = z
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END
