      PROGRAM  getgal
c
c...Compute Galactic Coordinates
c
      IMPLICIT
     *         NONE
      DOUBLE PRECISION
     *         rhh, rmm, rss, ddd, dmm, dss, r1950, d1950, pi,
     *         r2000, d2000, ll, bb, r50, d50, radian, r20, d20,
     *         north(6,937), south(6,894)
      INTEGER
     *         id, i, j
      CHARACTER*6
     *         survey
      CHARACTER*3
     *         ss
      CHARACTER*1
     *         dsign
c
 9001 FORMAT (i6, 23x, 3f2.0, 1x, a, 3f2.0, 22x, a)
 9002 FORMAT (i6, a, 20x, 3f2.0, 1x, a, 3f2.0)
 9003 FORMAT ('P1', i4, 6f11.6)
 9004 FORMAT ('SS', i4, 6f11.6)
c
c...Process NORTH
c
  100 pi = 4.0D00*ATAN(1.0D00)
      radian = pi/180.0D00
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='north.gal',
     *      status='unknown',
     *      unit=2
     *     )
      READ (1,9001)
  110 READ (1,9001,end=120) id,rhh,rmm,rss,dsign,ddd,dmm,dss,survey
      IF ((id.le.0).or.(id.gt.937)) GO TO 110
      IF (INDEX(survey,'O').le.0) GO TO 110
      r1950 = rhh + rmm/60.0D00 + rss/3600.0D00
      d1950 = ddd + dmm/60.0D00 + dss/3600.0D00
      IF (dsign.eq.'-') THEN
        d1950 = -d1950
      ENDIF
      r50 = r1950*15.0D00*radian
      d50 = d1950*radian
      CALL sla_FK45Z(r50,d50,1950.0D00,r20,d20)
      r2000 = r20/(15.0D00*radian)
      d2000 = d20/radian
      CALL sla_EQGAL(r20,d20,ll,bb)
      north(1,id) = r1950
      north(2,id) = d1950
      north(3,id) = r2000
      north(4,id) = d2000
      north(5,id) = ll/radian
      north(6,id) = bb/radian
      GO TO 110
  120 CLOSE (1)
c
c...Process South
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/south.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
  130 READ (1,9002,end=140) id,ss,rhh,rmm,rss,dsign,ddd,dmm,dss
      IF ((id.le.0).or.(id.gt.894)) GO TO 130
      IF (INDEX(ss,'SB').le.0) GO TO 130
      r1950 = rhh + rmm/60.0D00 + rss/3600.0D00
      d1950 = ddd + dmm/60.0D00 + dss/3600.0D00
      IF (dsign.eq.'-') THEN
        d1950 = -d1950
      ENDIF
      r50 = r1950*15.0D00*radian
      d50 = d1950*radian
      CALL sla_FK45Z(r50,d50,1950.0D00,r20,d20)
      r2000 = r20/(15.0D00*radian)
      d2000 = d20/radian
      CALL sla_EQGAL(r20,d20,ll,bb)
      south(1,id) = r1950
      south(2,id) = d1950
      south(3,id) = r2000
      south(4,id) = d2000
      south(5,id) = ll
      south(6,id) = bb
      GO TO 130
  140 CLOSE (1)
c
c...Save Everything
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='getgal.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,937
        WRITE (1,9003) i,(north(j,i),j=1,6)
      ENDDO
      DO i=1,894
        WRITE (1,9004) i,(south(j,i),j=1,6)
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
