      PROGRAM  tychoread
c
c...Test Parse Of TYCHO Catalog
c
      IMPLICIT
     *          NONE
      PARAMETER
     *          nmax = 1049971,
     *          nflag = 27
      INTEGER
     *          ticid1(NMAX), ticid2(NMAX), ra10mas(NMAX),
     *          spd10mas(NMAX), e_pos10mas(NMAX), e_b10mmag(NMAX),
     *          b10mmag(NMAX), e_v10mmag(NMAX), v10mmag(NMAX),
     *          flags(NMAX)
      INTEGER
     *          i, f(NFLAG), j, k
c
 9001 FORMAT (i4, 1x, i5, i10, i9, 1x, i4, 1x, i3, i5, 1x, i3, i5,
     *        1x, 27i1)
c
c...Open The Catalog
c
  100 OPEN (
     *       access='sequential',
     *       carriagecontrol='list',
     *       dispose='keep',
     *       form='formatted',
     *       name='tycho',
     *       readonly,
     *       shared,
     *       status='old',
     *       unit=1
     *      )
c
c...Read
c
      DO i=1,nmax
        READ (1,9001) ticid1(i),ticid2(i),ra10mas(i),spd10mas(i),
     *                e_pos10mas(i),e_b10mmag(i),b10mmag(i),
     *                e_v10mmag(i),v10mmag(i),(f(j),j=1,NFLAG)
        k = 0
        DO j=1,NFLAG
          k = k + f(j)*2**(j-1)
        ENDDO
        flags(i) = k
      ENDDO
      CLOSE (1)
c
c...Open And Save As A Direct Access File
c
      OPEN (
     *       access='direct',
     *       carriagecontrol='none',
     *       convert='big_endian',
     *       dispose='keep',
     *       form='unformatted',
     *       name='tycho.bin',
     *       recl=10,
     *       recordtype='fixed',
     *       status='unknown',
     *       unit=2
     *      )
      DO i=1,NMAX
        WRITE (2,rec=i) ticid1(i),ticid2(i),ra10mas(i),spd10mas(i),
     *                  e_pos10mas(i),e_b10mmag(i),b10mmag(i),
     *                  e_v10mmag(i),v10mmag(i),flags(i)
      ENDDO
      CLOSE (2)
      CALL EXIT
      END
