      program aapc
c
c Program to read a .dat file and apply the photometric calibration.
c This version includes de-vignetting.  (11/08/94 bjc)
c This version modified for automatic processing 28-Nov-94 AAH
c new vignetting fcn and file renames 31-Jan-95 AAH
c
      include 'apc.inc'
c
      real*8 pmmra(MAXSTARS), pmmdec(MAXSTARS), fld0ra, fld0dec, d2r, d2r2
      real*4 pmmmag(MAXSTARS), acoeff(4), truemag(MAXSTARS), val(25)
      real*4 pmmx(MAXSTARS), pmmy(MAXSTARS), vmag
      REAL*8 c0, c1, c2, c3, d1, d2, d3, discr, q, r, dmag
      integer*4 numobj, isign, imag(MAXSTARS), nf1, nf2, ii
      LOGICAL found
      character bname*4, pftfile*80, aline*80, outfile*80
      INTEGER errflg, phdflag
      common /blkz/ errflg
c
  1   format(a)
  3   format(t1,(a))
c
      write(6,5) 'A A P C', 'Automated Apply Photometric Calibration'
  5   format(/t38,(a)/t26,(a)/)
c
      d2r = datan(1.0d0)/4.5d1
      d2r2 = datan(1.0d0)/3.0d0
c
c get user input
c
      print *,'Enter starting fieldnumber: '
      read (5,*) nf1
      print *,'Enter ending fieldnumber: '
      read (5,*) nf2
      print *,'0=save, 1=overwrite existing .phd files: '
      read (5,*) phdflag
c
c loop over 894 possible fields
c
      do ii=nf1,nf2
        errflg = 0
        write (6,9002) ii
9002    format('processing file: ',i4.4)
        write(bname,9001) ii
9001    format(i4.4)
        pftfile = 'uj'//bname//'.pft'
        inquire(file=pftfile,exist=found)
        if (found) then
        pftfile = 'uj'//bname//'.phd'
        inquire(file=pftfile,exist=found)
        if (phdflag.eq.0.and.found) goto 10
        if (phdflag.eq.1.and.found) then
          open (unit=1,file=pftfile,status='old')
          close(1,status='delete')
        endif
        write(6,3) 'Working on field '//bname
        write(6,3) '. . .Reading .inf and .dat files. . .'
        call rd_infdat(bname,storage,numobj)
        if(errflg.eq.1) goto 10
        write(6,3) '. . .unpacking. . .'
        do i=1,numobj
         call unpack(i,val,storage)
c!       pmmmag(i) = val(10)	! FluxMag
         pmmmag(i) = val(9)	! FitMag
c!       pmmm9(i) = val(23)	! Mag9
         pmmx(i) = val(1)	! PMM X (microns)
         pmmy(i) = val(2)	! PMM Y (microns)
        end do
        write(6,3) '. . .reading .ird and catNNNN.inf files. . .'
        call rd_ird(pmmra,pmmdec,fld0ra,fld0dec,bname)
        if(errflg.eq.1) goto 10
c...Convert RA and dec to radians
        do i=1,numobj
         pmmra(i) = pmmra(i)*d2r2
         pmmdec(i) = pmmdec(i)*d2r
        end do
c
        write(6,3) '. . .reading .pft file. . .'
        pftfile = 'uj'//bname//'.pft'
        open(unit=11,file=pftfile,status='old')
        read(11,1) aline
        read(11,*) (acoeff(i),i=1,4)
        close(11)
c
c The coefficients ACOEFF are the Legendre polynomial expansion
c        y = acoeff(1)*L0 + acoeff(2)*L1 + acoeff(3)*L2 + acoeff(4)*L3
c We seek first the polynomial expansion
c        y = c0 + c1.x + c2.x^2 + c3.x^3
c
        c0 = acoeff(1) - 0.5*acoeff(3)
        c1 = acoeff(2) - 1.5*acoeff(4)
        c2 = 1.5*acoeff(3)
        c3 = 2.5*acoeff(4)
c
c Next we solve the cubic
c        0=(c0-y)/c3 + c1.x/c3 + c2.x^2/c3 + x^3
c and apply this, the inverse function of the photometric calibration curve,
c to the instrumental magnitudes.
c
        write(6,3) '. . .computing transformed magnitudes. . .'
        do i=1,numobj
         d0 = (c0 - pmmmag(i))/c3
         d1 = c1/c3
         d2 = c2/c3
         q = (d2**2 - 3.0*d1)/9.0
         r = (2.0*d2**3 - 9.0*d2*d1 + 27.0*d0)/54.0
         discr = (dsqrt(r**2 - q**3) + abs(r))**(1.0/3.0)
         if( r .lt. 0.0 ) then
            isign = 1
         else
            isign = -1
         end if
         truemag(i) = isign*(discr + q/discr) - d2/3.0
         call vignette(pmmx(i),pmmy(i),truemag(i),vmag)
         truemag(i) = truemag(i) - vmag
         imag(i) = nint(100.0*truemag(i))
        end do
c
        write(6,3) '. . .writing output. . .'
	outfile = 'uj'//bname//'.phd'
        open(unit=12,file=outfile,access='direct',carriagecontrol='none',
     &   dispose='keep',form='unformatted',recl=numobj,recordtype='fixed',
     &   status='new',err=91,convert='big_endian')
        write(12,rec=1) (imag(i),i=1,numobj)
        write(6,3) '. . .done.'
        endif
10      continue
        close(11)
        close(12)
        close(13)
      enddo
      stop
91    write (6,9008) outfile
9008  format ('ERROR: cannot open output file: ',a)
      stop
      end

      SUBROUTINE  rd_infdat(bname,thebuf,numobj)
c
c...Fill Arrays From BINARY Dump
c
      INCLUDE
     *            'cuproc.inc'
c
      real*4 magoffset, magslope
      INTEGER
     *            i, j, nlb, thebuf(4,NSMAX), tmpbuf(NSMAX), numobj
      CHARACTER
     *            lb*64, bname*4
      logical badtry
      common/magblk/ magoffset, magslope
      INTEGER errflg
      common /blkz/ errflg
c
 9004 FORMAT (t1,'Cannot open /uw0 or ', a)
 9005 FORMAT (2i10)
 9007 format(t1,(a))
c
c...Get Root And Read INF File
c
      fn2 = '/uw0/xpmm/lists/uj'//bname//'a'
      nfn2 = 23
      badtry = .false.
  100 lb = fn2(1:nfn2)//'.inf'
      nlb = nfn2 + 4
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9005) n2
      numobj = n2
      n2orig = n2
      read(1,*) magoffset, magslope
      CLOSE (1)
c
      if( n2 .gt. NSMAX ) then
         write(6,9007) 'Too many stars'
         errflg = 1
         return
      end if
c
c...Read The DAT File
c
      lb = fn2(1:nfn2)//'.dat'
      nlb = nfn2 + 4
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n2,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      DO j=1,NBIGBUF
         READ (1,rec=j) (tmpbuf(i),i=1,n2)
         if( j .eq. 4 ) then	! rec=4 packs FitMag & Mag9
            do i=1,n2
               thebuf(1,i) = tmpbuf(i)
            end do
         else if( j .eq. 9 ) then       !rec=9 packs PMMX
            do i=1,n2
               thebuf(2,i) = tmpbuf(i)
            end do
         else if( j .eq. 10 ) then      !rec=10 packs PMMY
            do i=1,n2
               thebuf(3,i) = tmpbuf(i)
            end do
         else if( j .eq. 3 ) then	! rec=3 packs M00
            do i=1,n2
               thebuf(4,i) = tmpbuf(i)
            end do
         end if
      ENDDO
      CLOSE (1)
      RETURN
c
c May need to look in both /uw0 and /uw1 for .INF and .DAT files
c
  200 if( .not. badtry ) then
         badtry = .true.
         fn2(4:4) = '1'
      else
         WRITE (*,9004) lb(1:nlb)
         errflg = 1
         return
      end if
      GO TO 100
      END
c
c
c
      subroutine unpack(who,val,tmp1buf)
c
c...Given Index, Return Unpacked Values
c
      include 'cuproc.inc'
c
      INTEGER*4
     *            who, arg(4), i, tmp1buf(4,NSMAX)
      REAL*4
     *            val(25)
c
c...Extract The Integers
c
100   do i=1,4
         arg(i) = tmp1buf(i,who)
      end do
c
c...Call BINFILL Glue
c
      CALL glue(arg,val)
      RETURN
      END
c
c
c
      SUBROUTINE  glue(arg,val)
c
c...Call BINFILL And Then Pass Back
c
      INTEGER*4
     *            arg(4), i
      REAL*8 pmmx,pmmy
      REAL*4
     *            val(25), mag, mag9, tmag
c
  100 CALL binfill(arg,mag,mag9,tmag,pmmx,pmmy)
      val(1) = pmmx
      val(2) = pmmy
      val(9) = mag	!FitMag
      val(10) = tmag	!FluxMag
      val(23) = m9	!Mag9
c
      RETURN
      END
c
c
c
      SUBROUTINE  binfill(in,mag,mag9,tmag,pmmx,pmmy)
c
c...Crack Values And Put In Passing Vector
c
      REAL*8 pmmx,pmmy
      real*4 magoffset, magslope, mag, mag9, tmag
      INTEGER*4
     *            in(4), low, mid, high, j
      common/magblk/ magoffset, magslope
c
c...Crack Magnitudes
c
100   j = in(1)
      high = j/10000
      low = j - high*10000
      mag = 0.01*low
      m9 = 0.01*high
c
      pmmx = 1.0d-2*in(2)
      pmmy = 1.0d-2*in(3)
c
      tmag = magoffset + magslope*(0.001*mod(in(4),10000))
c
      RETURN
      END

      SUBROUTINE VIGNETTE(x,y,mag,vmag)
c
c handle empirical vignetting function by table interpolation
c dimensions are (mag,rsq)
c
      REAL*4 table(11,14),tmag(11),mag,vmag,y1,y2,y3,y4,t,u
      REAL*4 x,y,xcent,ycent
      REAL*8 trsq(14),rsq
      INTEGER i,i1,i2,iflag
      DATA (table(i,1),i=2,10) /-.11,0.02,0.03,0.07,0.12,0.08,0.01,0.03,0.02/
      DATA (table(i,2),i=2,10) /-.05,0.04,0.04,0.07,0.12,0.08,0.00,0.01,0.01/
      DATA (table(i,3),i=2,10) /0.02,0.05,0.05,0.07,0.12,0.07,-.02,-.02,-.01/
      DATA (table(i,4),i=2,10) /0.09,0.05,0.05,0.06,0.10,0.06,-.04,-.04,-.02/
      DATA (table(i,5),i=2,10) /0.13,0.06,0.04,0.05,0.08,0.04,-.06,-.06,-.03/
      DATA (table(i,6),i=2,10) /0.16,0.06,0.03,0.03,0.05,0.02,-.07,-.10,-.05/
      DATA (table(i,7),i=2,10) /0.14,0.05,0.02,0.02,0.03,-.01,-.10,-.13,-.07/
      DATA (table(i,8),i=2,10) /0.13,0.05,-.01,-.01,0.00,-.05,-.14,-.15,-.09/
      DATA (table(i,9),i=2,10) /0.12,0.04,-.02,-.04,-.03,-.03,-.13,-.15,-.11/
      DATA (table(i,10),i=2,10)/0.10,0.03,0.01,-.01,0.00,-.01,-.09,-.05,-.04/
      DATA (table(i,11),i=2,10)/0.07,0.02,0.04,0.03,0.03,0.01,-.03,0.05,0.09/
      DATA (table(i,12),i=2,10)/0.03,0.01,0.08,0.07,0.07,0.04,0.02,0.22,0.18/
      DATA (table(i,13),i=2,10)/-.01,0.00,0.11,0.11,0.10,0.06,0.08,0.34,0.36/
      DATA (table(i,14),i=2,10)/-.03,-.01,0.15,0.15,0.14,0.09,0.14,0.48,0.48/
      DATA tmag /0.0,6.0,8.0,9.5,10.5,11.5,12.5,13.5,14.5,15.5,20.0/
      DATA trsq /0.0,4.0e8,1.6e9,3.6e9,6.4e9,1.0e10,1.44e10,1.96e10,
     $     2.56e10,3.24e10,4.0e10,4.84e10,5.76e10,6.76e10/
      DATA iflag /0/
      DATA xcent,ycent /170750.0,172000.0/
c
      if (iflag.eq.0) then
c set table limits
        do i=1,14
          table(1,i) = table(2,i)
          table(11,i) = table(10,i)
        enddo
        iflag = 1
      endif
c
      rsq = (x-xcent)**2 + (y-ycent)**2
      vmag = 0.0
      if (rsq.gt.trsq(14).or.mag.lt.tmag(1).or.mag.gt.tmag(11)) return
c find the corners appropriate to this mag,rsq
      i1 = 1
      i2 = 1
      do i=1,10
        if (mag.ge.tmag(i).and.mag.le.tmag(i+1)) then
          i1 = i
          goto 10
        endif
      enddo
10    continue
      do i=1,13
        if(rsq.ge.trsq(i).and.rsq.le.trsq(i+1)) then
          i2 = i
          goto 20
        endif
      enddo
20    continue
c
c now do bilinear interpolation ala numerical recipies p. 97
      y1 = table(i1,i2)
      y2 = table(i1+1,i2)
      y3 = table(i1+1,i2+1)
      y4 = table(i1,i2+1)
      t = (mag - tmag(i1))/(tmag(i1+1) - tmag(i1))
      u = (rsq - trsq(i2))/(trsq(i2+1) - trsq(i2))
      vmag = (1.-t)*(1.-u)*y1 + t*(1.-u)*y2 + t*u*y3 + (1.-t)*u*y4
      return
      end

c
c Angular separation of objects on the celestial sphere (<90 degrees).
c
      double precision function angsep(raa,deca,rab,decb)
c
      real*8 ra1, dec1, ra2, dec2, twopi, raa, rab, deca, decb
      parameter( twopi=6.2831853071796d0 )
c
      ra1 = raa
      dec1 = deca
      ra2 = rab
      dec2 = decb
c
c Test for RA crossing the 0h line
c
      if( abs(ra2 - ra1) .gt. 3.141593d0 ) then
         if( ra1 .lt. ra2 ) then
            ra2 = ra2 - twopi
         else
            ra1 = ra1 - twopi
         end if
      end if
c
      angsep = abs( dacos( dsin(dec1)*dsin(dec2) +
     & dcos(dec1)*dcos(dec2)*dcos(ra1 - ra2) ) )
c
      return
      end
c
c
c
      subroutine rd_ird(dra,ddec,fld0ra,fld0dec,bname)
c
c...Results In .IRD and .FIT Files
c
c Modified from Dave's dumpit.f
c
      include 'cuproc.inc'
c
      real*8 dra(NSMAX), ddec(NSMAX), fld0ra, fld0dec
      INTEGER*4 nlb, i, j, ra(NSMAX), spd(NSMAX), i2
      CHARACTER lb*64, bname*4, possline*80
      INTEGER errflg
      common /blkz/ errflg
c
 9002 FORMAT (2x, i10)
 9003 FORMAT (t1,'Cannot Open ', a)
 9004 FORMAT (a)
 9005 FORMAT (15i10)
 9006 FORMAT (2x, 4(1x, 1pe15.8))
c
c...Open The FIT File
c
      lb = '/uz6/xpmm/auxdu/du'//bname//'.fit'
      nlb = 26
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='old',
     *      unit=4
     *     )
      READ (4,9004) fn1
      nfn1 = 64
      do while( fn1(nfn1:nfn1) .eq. ' ' )
         nfn1 = nfn1 - 1
      end do
      READ (4,9004) fn2
      nfn2 = 64
      do while( fn2(nfn2:nfn2) .eq. ' ' )
         nfn2 = nfn2 - 1
      end do
      READ (4,9002) npair
      CLOSE (4)
c
c...Open The IRD File
c
      lb = '/uz6/xpmm/auxdu/du'//bname//'.ird'
      nlb = 26
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=n2orig,
     *      recordtype='fixed',
     *      status='old',
     *      unit=4
     *     )
      READ (4,rec=1) (   ra(i),i=1,n2orig)
      READ (4,rec=2) (  spd(i),i=1,n2orig)
      CLOSE (4)
c
      DO i=1,n2orig
        CALL radecinv(ra(i),spd(i),dra(i),ddec(i))
      ENDDO
c
c Read field center from catNNNN.inf file
c
      lb = '/uz6/xpmm/auxpat/pat'//bname//'.inf'
      nlb = 30
      open(unit=13,file=lb,status='old',err=200)
      read(13,9000) fld0ra,fld0dec
9000  format (29x,2f10.7)
      close(13)
      RETURN
c
c...Errors
c
  200 WRITE (*,9003) lb(1:nlb)
      errflg = 1
      return
      END
c
c
c
      SUBROUTINE  radecinv(ira,ispd,dra,ddec)
c
c Recover RA, Dec from IRA and ISPD
c
      INCLUDE
     *            'cuproc.inc'
      real*8 rfactor, dfactor
      PARAMETER(
     *            rfactor=1.5D1*3.6D3*1.0D2,
     *            dfactor=      3.6D3*1.0D2)
      INTEGER*4
     *            i, j, ixi, ieta, ira, ispd
      real*8
     *            x, y, m, xhat, yhat, dra, ddec
c
      dra = ira/rfactor
      ddec = ispd/dfactor - 9.0d1
c
      RETURN
      END
