      SUBROUTINE  fit3
c
c...Fit FIND1 Pairs Using Boxes
c
      INCLUDE
     *            'phcal.inc'
      PARAMETER
     *            wide = 200,
     *            tall = 40,
     *            wstep = 100,
     *            tstep = 20
      INTEGER
     *            i, w1, w2, w, frst, last, total, ymin, ymax, t1, t2,
     *            t, test, n, ier, lots, nmax
      DOUBLE PRECISION
     *            yvar, sx, sy, sxmax, symax
c
 9001 FORMAT (' FIT3 CUBGCV IER=', i10)
c
c...Sort Pairs On X
c
  100 nspl = 0
      np = npp
      DO i=1,npp
        jdx(i) = i
        px(i) = ppx(i)
        py(i) = ppy(i)
        pq(i) = ppq(i)
        pr(i) = ppr(i)
        ps(i) = pps(i)
      ENDDO
      CALL iuqsrt(np,px,jdx)
      CALL ireord(np,jdx,py,tmp)
      CALL ireord(np,jdx,pr,tmp)
      CALL ireord(np,jdx,pq,tmp)
      CALL ireord(np,jdx,ps,tmp)
      lots = 10
c
c...Loop Over Width
c
      w1 = (px(1)/WSTEP)*WSTEP
      w2 = (((px(np)-1)/WSTEP)+1)*WSTEP - WSTEP
      DO w=w1,w2,wstep
c
c...Find Limits, Extremes, And Total
c
        DO frst=1,np
          IF (px(frst).ge.(w     )) GO TO 110
        ENDDO
  110   DO last=np,frst,-1
          IF (px(last).le.(w+WIDE)) GO TO 120
        ENDDO
  120   total = (last+1-frst)
        ymin = py(frst)
        ymax = py(frst)
        DO i=frst+1,last
          ymin = MIN(ymin,py(i))
          ymax = MAX(ymax,py(i))
        ENDDO
        t1 = (ymax/TSTEP)*TSTEP
        IF (ymin.lt.0) THEN
          t2 = (((ymin+1)/TSTEP)-1)*TSTEP + TALL
        ELSE
          t2 = (((ymin-1)/TSTEP)+1)*TSTEP + TALL
        ENDIF
c
c...Count Stars In Box And Exit If More Than TEST
c
        test = total/3
        DO t=t1,t2,-TSTEP
          n = 0
          sx = 0.0D00
          sy = 0.0D00
          DO i=frst,last
            IF ((py(i).le.t).and.(py(i).ge.(t-TALL))) THEN
              n = n+1
              sx = sx + px(i)
              sy = sy + py(i)
            ENDIF
          ENDDO
          IF (n.gt.0) THEN
            sx = sx/n
            sy = sy/n
          ENDIF
          IF (t.eq.t1) THEN
            nmax = n
            sxmax = sx
            symax = sy
          ELSE
            IF (n.gt.nmax) THEN
              nmax = n
              sxmax = sx
              symax = sy
            ENDIF
          ENDIF
          IF (n.ge.test) THEN
            nspl = nspl+1
            splx(nspl) = sx
            sply(nspl) = sy
            yw(nspl) = 1.0D00
            jdx(nspl) = nspl
            GO TO 130
          ENDIF
        ENDDO
c
c...Patch To Choose Local Maximum If There Were Lots Of Stars In This Bin
c
        IF (nmax.gt.lots) THEN
          nspl = nspl+1
          splx(nspl) = sxmax
          sply(nspl) = symax
          yw(nspl) = 1.0D00
          jdx(nspl) = nspl
        ENDIF
  130   CONTINUE
      ENDDO
c
c...Spline These.  Almost Anything Can Go Wrong, So Sort Again!
c
      CALL duqsrt(nspl,splx,jdx)
      CALL dreord(nspl,jdx,sply,tmp)
      DO i=2,nspl
        IF (splx(i).le.splx(i-1)) THEN
          splx(i) = splx(i-1) + 0.1D00
        ENDIF
      ENDDO
      yvar = -1.0D00
      CALL cubgcv(splx,sply,yw,nspl, yc,ycoef,NCODIM,
     *            yvar,0,se,wk,ier)
      IF (ier.ne.0) THEN
        WRITE (*,9001) ier
        CALL EXIT
      ENDIF
c
c...Fill FITDM Array From Splines
c
      DO i=BRIGHTMAG,FAINTMAG
        fitdm(i) = MAGTAG
      ENDDO
      w1 = splx(1)
      w2 = splx(nspl)+0.5D00
      n = 1
      DO w=w1,w2
        sx = w
        IF (n.lt.nspl) THEN
          IF (sx.gt.splx(n+1)) THEN
            n = n+1
          ENDIF
        ENDIF
        sy = sx-splx(n)
        fitdm(w) = yc(n)
     *           + sy*(ycoef(n,1) + sy*(ycoef(n,2) + sy*ycoef(n,3)))
        IF (w.eq.w1) THEN
          rangemin = fitdm(w)
          rangemax = fitdm(w)
        ELSE
          rangemin = MIN(rangemin,fitdm(w))
          rangemax = MAX(rangemax,fitdm(w))
        ENDIF
      ENDDO
      RETURN
      END
