      SUBROUTINE  fit4(ncoef)
c
c...Least Squares Fit To Pairs
c
      INCLUDE
     *            'phcal.inc'
      DOUBLE PRECISION
     *            chisq, x, y, yy, yr, dx, dy
      INTEGER
     *            i, j, k, ncoef, ising, nin, w1, w2, w
c
 9001 FORMAT (' Singular Matrix In FIT4')
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        coef(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      nin = 0
      fatal = 0
c
c...Accumulation
c
      DO i=1,nspl
        IF (infit(i).ne.0) THEN
          x = splx(i)
          y = sply(i)
          dv(1) = 1.0D00
          DO j=2,ncoef
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,ncoef
            zlhs(j) = zlhs(j) + dv(j)*y
            DO k=1,ncoef
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Inversion
c
      CALL matinv(ncoef,ising)
      IF (ising.ne.0) THEN
        fatal = 1
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals and Chi Sqaured
c
      length = 0.0D00
      DO i=1,nspl
        x = splx(i)
        y = sply(i)
        dv(1) = 1.0D00
        DO j=2,ncoef
          dv(j) = dv(j-1)*x
        ENDDO
        yy = 0.0D00
        DO j=1,ncoef
          yy = yy + coef(j)*dv(j)
        ENDDO
        yr = y-yy
        IF (infit(i).ne.0) THEN
          chisq = chisq + yr*yr
        ENDIF
        se(i) = yr
        IF (i.ge.2) THEN
          dx = splx(i)-splx(i-1)
          dy = yy - (sply(i-1)-se(i-1))
          length = length + SQRT(dx*dx + dy*dy)
        ENDIF
      ENDDO
c
c...Errors
c
      i = MAX(1,nin-(ncoef+1))
      stderr = SQRT(chisq/i)
      DO i=1,ncoef
        scoef(i) = stderr*SQRT(zrhs(i,i))
      ENDDO
c
c...Fill FITDM
c
      w1 = splx(1)
      w2 = splx(nspl)+0.5D00
      DO w=BRIGHTMAG,w1-1
        fitdm(w) = sply(1)-se(1)
      ENDDO
      DO w=w1,w2
        x = w
        dv(1) = 1.0D00
        DO i=2,ncoef
          dv(i) = dv(i-1)*x
        ENDDO
        yy = 0.0D00
        DO i=1,ncoef
          yy = yy + dv(i)*coef(i)
        ENDDO
        fitdm(w) = yy+0.5D00
        IF (w.eq.w1) THEN
          rangemin = fitdm(w)
          rangemax = fitdm(w)
        ELSE
          rangemin = MIN(rangemin,fitdm(w))
          rangemax = MAX(rangemax,fitdm(w))
        ENDIF
      ENDDO
      DO w=w2+1,FAINTMAG
        fitdm(w) = sply(nspl)-se(nspl)
      ENDDO
      RETURN
      END
