      SUBROUTINE  find1(arcsec)
c
c...First Iteration Of Finder.  Take Closest In Magntidue Inside Of Radius
c
      INCLUDE
     *            'phcal.inc'
      PARAMETER
     *            factor = (3600.0D00*100.0D00),
     *            nemax = 1000
      INTEGER
     *            test, xtest, ytest, mtest, dx, dy, xmin, xmax,
     *            ymin, ymax, low, high, er(NEMAX), ey(NEMAX),
     *            ex(NEMAX), ne, i, eq(NEMAX), es(NEMAX), j, k
      DOUBLE PRECISION
     *            d, cd, deltax, deltay, deltar, arcsec, radius, rsquare
c
c...Initilaization
c
  100 radius = arcsec*100.0D00
      rsquare = radius*radius
      np = 0
      test = 0
      low = 1
      high = 1
c
c...Increment TEST And Compute Limits
c
  110 test = test+1
      IF (test.gt.nq) RETURN
      xtest = qra(test)
      ytest = qdec(test)
      mtest = qmag(test)
      d = (ytest/FACTOR)-90.0D00
      cd = COSD(d)
      dx = RADIUS/cd
      dy = RADIUS
      xmin = xtest-dx
      xmax = xtest+dx
      ymin = ytest-dy
      ymax = ytest+dy
c
c...Update LOW Index
c
  120 IF (low.lt.ns) THEN
        IF (sra(low).lt.xmin) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (sra(low).gt.xmax) GO TO 110
c
c...Update HIGH Index
c
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 IF (high.lt.ns) THEN
        IF (sra(high+1).le.xmax) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Examine All Stars In This Range
c
      ne = 0
      DO i=low,high
        IF ((sdec(i).ge.ymin).and.(sdec(i).le.ymax)) THEN
          deltax = (sra(i)-xtest)*cd
          deltay = (sdec(i)-ytest)
          deltar = deltax*deltax + deltay*deltay
          IF (deltar.le.RSQUARE) THEN
            ne = ne+1
            er(ne) = deltar
            ex(ne) = mtest
            ey(ne) = mtest-smag(i)
            eq(ne) = test
            es(ne) = i
          ENDIF
        ENDIF
      ENDDO
c
c...Save Results.  Choose Brightest If More Than One
c
      IF (ne.gt.0) THEN
        j = 1
        k = ey(j)
        DO i=2,ne
          IF (ey(i).gt.k) THEN
            j = i
            k = ey(i)
          ENDIF
        ENDDO
        np = np+1
        pq(np) = eq(j)
        ps(np) = es(j)
        px(np) = ex(j)
        py(np) = ey(j)
        pr(np) = er(j)
      ENDIF
      GO TO 110
      END
